/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi.sql;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.internal.util.collections.ArrayHelper;

public class NativeSQLQuerySpecification {
    private final String queryString;
    private final NativeSQLQueryReturn[] queryReturns;
    private final Set querySpaces;
    private final int hashCode;

    public NativeSQLQuerySpecification(String string, NativeSQLQueryReturn[] nativeSQLQueryReturnArray, Collection collection) {
        this.queryString = string;
        this.queryReturns = nativeSQLQueryReturnArray;
        if (collection == null) {
            this.querySpaces = Collections.EMPTY_SET;
        } else {
            HashSet hashSet = new HashSet();
            hashSet.addAll(collection);
            this.querySpaces = Collections.unmodifiableSet(hashSet);
        }
        int n = string.hashCode();
        n = 29 * n + this.querySpaces.hashCode();
        if (this.queryReturns != null) {
            n = 29 * n + ArrayHelper.toList(this.queryReturns).hashCode();
        }
        this.hashCode = n;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public NativeSQLQueryReturn[] getQueryReturns() {
        return this.queryReturns;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NativeSQLQuerySpecification nativeSQLQuerySpecification = (NativeSQLQuerySpecification)object;
        return this.querySpaces.equals(nativeSQLQuerySpecification.querySpaces) && this.queryString.equals(nativeSQLQuerySpecification.queryString) && Arrays.equals(this.queryReturns, nativeSQLQuerySpecification.queryReturns);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

