/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi.sql;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativeSQLQueryNonScalarReturn
implements NativeSQLQueryReturn,
Serializable {
    private final String alias;
    private final LockMode lockMode;
    private final Map<String, String[]> propertyResults = new HashMap<String, String[]>();
    private final int hashCode;

    protected NativeSQLQueryNonScalarReturn(String string, Map<String, String[]> map, LockMode lockMode) {
        this.alias = string;
        if (string == null) {
            throw new HibernateException("alias must be specified");
        }
        this.lockMode = lockMode;
        if (map != null) {
            this.propertyResults.putAll(map);
        }
        this.hashCode = this.determineHashCode();
    }

    public String getAlias() {
        return this.alias;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public Map<String, String[]> getPropertyResultsMap() {
        return Collections.unmodifiableMap(this.propertyResults);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int determineHashCode() {
        int n = this.alias != null ? this.alias.hashCode() : 0;
        n = 31 * n + this.getClass().getName().hashCode();
        n = 31 * n + (this.lockMode != null ? this.lockMode.hashCode() : 0);
        n = 31 * n + (this.propertyResults != null ? this.propertyResults.hashCode() : 0);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NativeSQLQueryNonScalarReturn nativeSQLQueryNonScalarReturn = (NativeSQLQueryNonScalarReturn)object;
        if (this.alias != null ? !this.alias.equals(nativeSQLQueryNonScalarReturn.alias) : nativeSQLQueryNonScalarReturn.alias != null) {
            return false;
        }
        if (this.lockMode != null ? !this.lockMode.equals((Object)nativeSQLQueryNonScalarReturn.lockMode) : nativeSQLQueryNonScalarReturn.lockMode != null) {
            return false;
        }
        return !(this.propertyResults != null ? !this.propertyResults.equals(nativeSQLQueryNonScalarReturn.propertyResults) : nativeSQLQueryNonScalarReturn.propertyResults != null);
    }
}

