/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.engine.query.spi.FilterQueryPlan;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.engine.query.spi.ParamLocationRecognizer;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.FilterImpl;
import org.hibernate.internal.util.collections.BoundedConcurrentHashMap;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

public class QueryPlanCache
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, QueryPlanCache.class.getName());
    public static final int DEFAULT_PARAMETER_METADATA_MAX_COUNT = 128;
    public static final int DEFAULT_QUERY_PLAN_MAX_COUNT = 2048;
    private final SessionFactoryImplementor factory;
    private final BoundedConcurrentHashMap queryPlanCache;
    private final BoundedConcurrentHashMap<String, ParameterMetadata> parameterMetadataCache;

    public QueryPlanCache(SessionFactoryImplementor sessionFactoryImplementor) {
        Integer n;
        this.factory = sessionFactoryImplementor;
        Integer n2 = ConfigurationHelper.getInteger("hibernate.query.plan_parameter_metadata_max_size", sessionFactoryImplementor.getProperties());
        if (n2 == null) {
            n2 = ConfigurationHelper.getInt("hibernate.query.plan_cache_max_strong_references", sessionFactoryImplementor.getProperties(), 128);
        }
        if ((n = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", sessionFactoryImplementor.getProperties())) == null) {
            n = ConfigurationHelper.getInt("hibernate.query.plan_cache_max_soft_references", sessionFactoryImplementor.getProperties(), 2048);
        }
        this.queryPlanCache = new BoundedConcurrentHashMap(n, 20, BoundedConcurrentHashMap.Eviction.LIRS);
        this.parameterMetadataCache = new BoundedConcurrentHashMap(n2, 20, BoundedConcurrentHashMap.Eviction.LIRS);
    }

    public ParameterMetadata getSQLParameterMetadata(String string) {
        ParameterMetadata parameterMetadata = this.parameterMetadataCache.get(string);
        if (parameterMetadata == null) {
            parameterMetadata = this.buildParameterMetadata(string);
            this.parameterMetadataCache.putIfAbsent(string, parameterMetadata);
        }
        return parameterMetadata;
    }

    private ParameterMetadata buildParameterMetadata(String string) {
        Object object;
        ParamLocationRecognizer paramLocationRecognizer = ParamLocationRecognizer.parseLocations(string);
        int n = paramLocationRecognizer.getOrdinalParameterLocationList().size();
        OrdinalParameterDescriptor[] ordinalParameterDescriptorArray = new OrdinalParameterDescriptor[n];
        for (int i = 0; i < n; ++i) {
            object = paramLocationRecognizer.getOrdinalParameterLocationList().get(i);
            ordinalParameterDescriptorArray[i] = new OrdinalParameterDescriptor(i, null, (Integer)object);
        }
        HashMap<String, NamedParameterDescriptor> hashMap = new HashMap<String, NamedParameterDescriptor>();
        object = paramLocationRecognizer.getNamedParameterDescriptionMap();
        for (String string2 : object.keySet()) {
            ParamLocationRecognizer.NamedParameterDescription namedParameterDescription = (ParamLocationRecognizer.NamedParameterDescription)object.get(string2);
            hashMap.put(string2, new NamedParameterDescriptor(string2, null, namedParameterDescription.buildPositionsArray(), namedParameterDescription.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalParameterDescriptorArray, hashMap);
    }

    public HQLQueryPlan getHQLQueryPlan(String string, boolean bl, Map map) throws QueryException, MappingException {
        HQLQueryPlanKey hQLQueryPlanKey = new HQLQueryPlanKey(string, bl, map);
        HQLQueryPlan hQLQueryPlan = (HQLQueryPlan)this.queryPlanCache.get(hQLQueryPlanKey);
        if (hQLQueryPlan == null) {
            LOG.tracev("Unable to locate HQL query plan in cache; generating ({0})", (Object)string);
            hQLQueryPlan = new HQLQueryPlan(string, bl, map, this.factory);
            this.queryPlanCache.putIfAbsent(hQLQueryPlanKey, hQLQueryPlan);
        } else {
            LOG.tracev("Located HQL query plan in cache ({0})", (Object)string);
        }
        return hQLQueryPlan;
    }

    public FilterQueryPlan getFilterQueryPlan(String string, String string2, boolean bl, Map map) throws QueryException, MappingException {
        FilterQueryPlanKey filterQueryPlanKey = new FilterQueryPlanKey(string, string2, bl, map);
        FilterQueryPlan filterQueryPlan = (FilterQueryPlan)this.queryPlanCache.get(filterQueryPlanKey);
        if (filterQueryPlan == null) {
            LOG.tracev("Unable to locate collection-filter query plan in cache; generating ({0} : {1} )", (Object)string2, (Object)string);
            filterQueryPlan = new FilterQueryPlan(string, string2, bl, map, this.factory);
            this.queryPlanCache.putIfAbsent(filterQueryPlanKey, filterQueryPlan);
        } else {
            LOG.tracev("Located collection-filter query plan in cache ({0} : {1})", (Object)string2, (Object)string);
        }
        return filterQueryPlan;
    }

    public NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification) {
        NativeSQLQueryPlan nativeSQLQueryPlan = (NativeSQLQueryPlan)this.queryPlanCache.get(nativeSQLQuerySpecification);
        if (nativeSQLQueryPlan == null) {
            LOG.tracev("Unable to locate native-sql query plan in cache; generating ({0})", (Object)nativeSQLQuerySpecification.getQueryString());
            nativeSQLQueryPlan = new NativeSQLQueryPlan(nativeSQLQuerySpecification, this.factory);
            this.queryPlanCache.putIfAbsent(nativeSQLQuerySpecification, nativeSQLQueryPlan);
        } else {
            LOG.tracev("Located native-sql query plan in cache ({0})", (Object)nativeSQLQuerySpecification.getQueryString());
        }
        return nativeSQLQueryPlan;
    }

    public void cleanup() {
        LOG.trace("Cleaning QueryPlan Cache");
        this.queryPlanCache.clear();
        this.parameterMetadataCache.clear();
    }

    private static class FilterQueryPlanKey
    implements Serializable {
        private final String query;
        private final String collectionRole;
        private final boolean shallow;
        private final Set<String> filterNames;
        private final int hashCode;

        public FilterQueryPlanKey(String string, String string2, boolean bl, Map map) {
            this.query = string;
            this.collectionRole = string2;
            this.shallow = bl;
            if (CollectionHelper.isEmpty(map)) {
                this.filterNames = Collections.emptySet();
            } else {
                HashSet hashSet = new HashSet();
                hashSet.addAll(map.keySet());
                this.filterNames = Collections.unmodifiableSet(hashSet);
            }
            int n = string.hashCode();
            n = 29 * n + string2.hashCode();
            n = 29 * n + (bl ? 1 : 0);
            this.hashCode = n = 29 * n + this.filterNames.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            FilterQueryPlanKey filterQueryPlanKey = (FilterQueryPlanKey)object;
            return this.shallow == filterQueryPlanKey.shallow && this.filterNames.equals(filterQueryPlanKey.filterNames) && this.query.equals(filterQueryPlanKey.query) && this.collectionRole.equals(filterQueryPlanKey.collectionRole);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class DynamicFilterKey
    implements Serializable {
        private final String filterName;
        private final Map<String, Integer> parameterMetadata;
        private final int hashCode;

        private DynamicFilterKey(FilterImpl filterImpl) {
            this.filterName = filterImpl.getName();
            if (filterImpl.getParameters().isEmpty()) {
                this.parameterMetadata = Collections.emptyMap();
            } else {
                this.parameterMetadata = new HashMap<String, Integer>(CollectionHelper.determineProperSizing(filterImpl.getParameters()), 0.75f);
                Iterator<Map.Entry<String, ?>> iterator = filterImpl.getParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ?> entry;
                    Map.Entry<String, ?> entry2 = entry = iterator.next();
                    String string = entry2.getKey();
                    Integer n = Collection.class.isInstance(entry2.getValue()) ? Integer.valueOf(((Collection)entry2.getValue()).size()) : Integer.valueOf(1);
                    this.parameterMetadata.put(string, n);
                }
            }
            int n = this.filterName.hashCode();
            this.hashCode = n = 31 * n + this.parameterMetadata.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DynamicFilterKey dynamicFilterKey = (DynamicFilterKey)object;
            return this.filterName.equals(dynamicFilterKey.filterName) && this.parameterMetadata.equals(dynamicFilterKey.parameterMetadata);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class HQLQueryPlanKey
    implements Serializable {
        private final String query;
        private final boolean shallow;
        private final Set<DynamicFilterKey> filterKeys;
        private final int hashCode;

        public HQLQueryPlanKey(String string, boolean bl, Map map) {
            this.query = string;
            this.shallow = bl;
            if (CollectionHelper.isEmpty(map)) {
                this.filterKeys = Collections.emptySet();
            } else {
                HashSet<DynamicFilterKey> hashSet = new HashSet<DynamicFilterKey>(CollectionHelper.determineProperSizing(map), 0.75f);
                for (Object v : map.values()) {
                    hashSet.add(new DynamicFilterKey((FilterImpl)v));
                }
                this.filterKeys = Collections.unmodifiableSet(hashSet);
            }
            int n = string.hashCode();
            n = 29 * n + (bl ? 1 : 0);
            this.hashCode = n = 29 * n + this.filterKeys.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HQLQueryPlanKey hQLQueryPlanKey = (HQLQueryPlanKey)object;
            return this.shallow == hQLQueryPlanKey.shallow && this.filterKeys.equals(hQLQueryPlanKey.filterKeys) && this.query.equals(hQLQueryPlanKey.query);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

