/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.QueryParameterException;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.type.Type;

public class ParameterMetadata
implements Serializable {
    private static final OrdinalParameterDescriptor[] EMPTY_ORDINALS = new OrdinalParameterDescriptor[0];
    private final OrdinalParameterDescriptor[] ordinalDescriptors;
    private final Map namedDescriptorMap;

    public ParameterMetadata(OrdinalParameterDescriptor[] ordinalParameterDescriptorArray, Map map) {
        if (ordinalParameterDescriptorArray == null) {
            this.ordinalDescriptors = EMPTY_ORDINALS;
        } else {
            OrdinalParameterDescriptor[] ordinalParameterDescriptorArray2 = new OrdinalParameterDescriptor[ordinalParameterDescriptorArray.length];
            System.arraycopy(ordinalParameterDescriptorArray, 0, ordinalParameterDescriptorArray2, 0, ordinalParameterDescriptorArray.length);
            this.ordinalDescriptors = ordinalParameterDescriptorArray2;
        }
        if (map == null) {
            this.namedDescriptorMap = Collections.EMPTY_MAP;
        } else {
            int n = (int)((double)map.size() / 0.75 + 1.0);
            HashMap hashMap = new HashMap(n);
            hashMap.putAll(map);
            this.namedDescriptorMap = Collections.unmodifiableMap(hashMap);
        }
    }

    public int getOrdinalParameterCount() {
        return this.ordinalDescriptors.length;
    }

    public OrdinalParameterDescriptor getOrdinalParameterDescriptor(int n) {
        if (n < 1 || n > this.ordinalDescriptors.length) {
            String string = "Position beyond number of declared ordinal parameters. Remember that ordinal parameters are 1-based! Position: " + n;
            throw new QueryParameterException(string);
        }
        return this.ordinalDescriptors[n - 1];
    }

    public Type getOrdinalParameterExpectedType(int n) {
        return this.getOrdinalParameterDescriptor(n).getExpectedType();
    }

    public int getOrdinalParameterSourceLocation(int n) {
        return this.getOrdinalParameterDescriptor(n).getSourceLocation();
    }

    public Set getNamedParameterNames() {
        return this.namedDescriptorMap.keySet();
    }

    public NamedParameterDescriptor getNamedParameterDescriptor(String string) {
        NamedParameterDescriptor namedParameterDescriptor = (NamedParameterDescriptor)this.namedDescriptorMap.get(string);
        if (namedParameterDescriptor == null) {
            throw new QueryParameterException("could not locate named parameter [" + string + "]");
        }
        return namedParameterDescriptor;
    }

    public Type getNamedParameterExpectedType(String string) {
        return this.getNamedParameterDescriptor(string).getExpectedType();
    }

    public int[] getNamedParameterSourceLocations(String string) {
        return this.getNamedParameterDescriptor(string).getSourceLocations();
    }
}

