/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.query.spi.ParameterParser;
import org.hibernate.internal.util.collections.ArrayHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamLocationRecognizer
implements ParameterParser.Recognizer {
    private Map<String, NamedParameterDescription> namedParameterDescriptions = new HashMap<String, NamedParameterDescription>();
    private List<Integer> ordinalParameterLocationList = new ArrayList<Integer>();

    public static ParamLocationRecognizer parseLocations(String string) {
        ParamLocationRecognizer paramLocationRecognizer = new ParamLocationRecognizer();
        ParameterParser.parse(string, paramLocationRecognizer);
        return paramLocationRecognizer;
    }

    public Map<String, NamedParameterDescription> getNamedParameterDescriptionMap() {
        return this.namedParameterDescriptions;
    }

    public List<Integer> getOrdinalParameterLocationList() {
        return this.ordinalParameterLocationList;
    }

    @Override
    public void ordinalParameter(int n) {
        this.ordinalParameterLocationList.add(n);
    }

    @Override
    public void namedParameter(String string, int n) {
        this.getOrBuildNamedParameterDescription(string, false).add(n);
    }

    @Override
    public void jpaPositionalParameter(String string, int n) {
        this.getOrBuildNamedParameterDescription(string, true).add(n);
    }

    private NamedParameterDescription getOrBuildNamedParameterDescription(String string, boolean bl) {
        NamedParameterDescription namedParameterDescription = this.namedParameterDescriptions.get(string);
        if (namedParameterDescription == null) {
            namedParameterDescription = new NamedParameterDescription(bl);
            this.namedParameterDescriptions.put(string, namedParameterDescription);
        }
        return namedParameterDescription;
    }

    @Override
    public void other(char c) {
    }

    @Override
    public void outParameter(int n) {
    }

    public static class NamedParameterDescription {
        private final boolean jpaStyle;
        private final List<Integer> positions = new ArrayList<Integer>();

        public NamedParameterDescription(boolean bl) {
            this.jpaStyle = bl;
        }

        public boolean isJpaStyle() {
            return this.jpaStyle;
        }

        private void add(int n) {
            this.positions.add(n);
        }

        public int[] buildPositionsArray() {
            return ArrayHelper.toIntArray(this.positions);
        }
    }
}

