/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.custom.sql.SQLCustomQuery;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class NativeSQLQueryPlan
implements Serializable {
    private final String sourceQuery;
    private final SQLCustomQuery customQuery;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NativeSQLQueryPlan.class.getName());

    public NativeSQLQueryPlan(NativeSQLQuerySpecification nativeSQLQuerySpecification, SessionFactoryImplementor sessionFactoryImplementor) {
        this.sourceQuery = nativeSQLQuerySpecification.getQueryString();
        this.customQuery = new SQLCustomQuery(nativeSQLQuerySpecification.getQueryString(), nativeSQLQuerySpecification.getQueryReturns(), nativeSQLQuerySpecification.getQuerySpaces(), sessionFactoryImplementor);
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public SQLCustomQuery getCustomQuery() {
        return this.customQuery;
    }

    private int[] getNamedParameterLocs(String string) throws QueryException {
        Object v = this.customQuery.getNamedParameterBindPoints().get(string);
        if (v == null) {
            throw new QueryException("Named parameter does not appear in Query: " + string, this.customQuery.getSQL());
        }
        if (v instanceof Integer) {
            return new int[]{(Integer)v};
        }
        return ArrayHelper.toIntArray((List)v);
    }

    private int bindPositionalParameters(PreparedStatement preparedStatement, QueryParameters queryParameters, int n, SessionImplementor sessionImplementor) throws SQLException {
        Object[] objectArray = queryParameters.getFilteredPositionalParameterValues();
        Type[] typeArray = queryParameters.getFilteredPositionalParameterTypes();
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            typeArray[i].nullSafeSet(preparedStatement, objectArray[i], n + n2, sessionImplementor);
            n2 += typeArray[i].getColumnSpan(sessionImplementor.getFactory());
        }
        return n2;
    }

    private int bindNamedParameters(PreparedStatement preparedStatement, Map map, int n, SessionImplementor sessionImplementor) throws SQLException {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                TypedValue typedValue = (TypedValue)entry.getValue();
                int[] nArray = this.getNamedParameterLocs(string);
                for (int i = 0; i < nArray.length; ++i) {
                    LOG.debugf("bindNamedParameters() %s -> %s [%s]", typedValue.getValue(), (Object)string, (Object)(nArray[i] + n));
                    typedValue.getType().nullSafeSet(preparedStatement, typedValue.getValue(), nArray[i] + n, sessionImplementor);
                }
                n2 += nArray.length;
            }
            return n2;
        }
        return 0;
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor sessionImplementor) {
        BulkOperationCleanupAction bulkOperationCleanupAction = new BulkOperationCleanupAction(sessionImplementor, this.getCustomQuery().getQuerySpaces());
        if (sessionImplementor.isEventSource()) {
            ((EventSource)sessionImplementor).getActionQueue().addAction(bulkOperationCleanupAction);
        } else {
            bulkOperationCleanupAction.getAfterTransactionCompletionProcess().doAfterTransactionCompletion(true, sessionImplementor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        this.coordinateSharedCacheCleanup(sessionImplementor);
        if (queryParameters.isCallable()) {
            throw new IllegalArgumentException("callable not yet supported for native queries");
        }
        int n = 0;
        try {
            queryParameters.processFilters(this.customQuery.getSQL(), sessionImplementor);
            String string = queryParameters.getFilteredSQL();
            PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string, false);
            try {
                int n2 = 1;
                n2 += this.bindPositionalParameters(preparedStatement, queryParameters, n2, sessionImplementor);
                n2 += this.bindNamedParameters(preparedStatement, queryParameters.getNamedParameters(), n2, sessionImplementor);
                n = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
            }
            finally {
                if (preparedStatement != null) {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                }
            }
        }
        catch (SQLException sQLException) {
            throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not execute native bulk manipulation query", this.sourceQuery);
        }
        return n;
    }
}

