/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.engine.query.spi.ParamLocationRecognizer;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.ReturnMetadata;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.QuerySplitter;
import org.hibernate.hql.spi.FilterTranslator;
import org.hibernate.hql.spi.ParameterTranslations;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.hql.spi.QueryTranslatorFactory;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.EmptyIterator;
import org.hibernate.internal.util.collections.IdentitySet;
import org.hibernate.internal.util.collections.JoinedIterator;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class HQLQueryPlan
implements Serializable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, HQLQueryPlan.class.getName());
    private final String sourceQuery;
    private final QueryTranslator[] translators;
    private final String[] sqlStrings;
    private final ParameterMetadata parameterMetadata;
    private final ReturnMetadata returnMetadata;
    private final Set querySpaces;
    private final Set enabledFilterNames;
    private final boolean shallow;

    public HQLQueryPlan(String string, boolean bl, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        this(string, null, bl, map, sessionFactoryImplementor);
    }

    protected HQLQueryPlan(String string, String string2, boolean bl, Map map, SessionFactoryImplementor sessionFactoryImplementor) {
        this.sourceQuery = string;
        this.shallow = bl;
        HashSet hashSet = new HashSet();
        hashSet.addAll(map.keySet());
        this.enabledFilterNames = Collections.unmodifiableSet(hashSet);
        String[] stringArray = QuerySplitter.concreteQueries(string, sessionFactoryImplementor);
        int n = stringArray.length;
        this.translators = new QueryTranslator[n];
        ArrayList<String> arrayList = new ArrayList<String>();
        HashSet hashSet2 = new HashSet();
        boolean bl2 = string2 == null;
        Map map2 = sessionFactoryImplementor.getSettings().getQuerySubstitutions();
        QueryTranslatorFactory queryTranslatorFactory = sessionFactoryImplementor.getSettings().getQueryTranslatorFactory();
        for (int i = 0; i < n; ++i) {
            if (bl2) {
                this.translators[i] = queryTranslatorFactory.createQueryTranslator(string, stringArray[i], map, sessionFactoryImplementor);
                this.translators[i].compile(map2, bl);
            } else {
                this.translators[i] = queryTranslatorFactory.createFilterTranslator(string, stringArray[i], map, sessionFactoryImplementor);
                ((FilterTranslator)this.translators[i]).compile(string2, map2, bl);
            }
            hashSet2.addAll(this.translators[i].getQuerySpaces());
            arrayList.addAll(this.translators[i].collectSqlStrings());
        }
        this.sqlStrings = ArrayHelper.toStringArray(arrayList);
        this.querySpaces = hashSet2;
        if (n == 0) {
            this.parameterMetadata = new ParameterMetadata(null, null);
            this.returnMetadata = null;
        } else {
            this.parameterMetadata = this.buildParameterMetadata(this.translators[0].getParameterTranslations(), string);
            if (this.translators[0].isManipulationStatement()) {
                this.returnMetadata = null;
            } else {
                Type[] typeArray = n > 1 ? new Type[this.translators[0].getReturnTypes().length] : this.translators[0].getReturnTypes();
                this.returnMetadata = new ReturnMetadata(this.translators[0].getReturnAliases(), typeArray);
            }
        }
    }

    public String getSourceQuery() {
        return this.sourceQuery;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public ParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public ReturnMetadata getReturnMetadata() {
        return this.returnMetadata;
    }

    public Set getEnabledFilterNames() {
        return this.enabledFilterNames;
    }

    public String[] getSqlStrings() {
        return this.sqlStrings;
    }

    public Set getUtilizedFilterNames() {
        return null;
    }

    public boolean isShallow() {
        return this.shallow;
    }

    public List performList(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        QueryParameters queryParameters2;
        Object object;
        boolean bl;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Find: {0}", (Object)this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        boolean bl2 = queryParameters.getRowSelection() != null && queryParameters.getRowSelection().definesLimits();
        boolean bl3 = bl = bl2 && this.translators.length > 1;
        if (bl) {
            LOG.needsLimit();
            object = new RowSelection();
            ((RowSelection)object).setFetchSize(queryParameters.getRowSelection().getFetchSize());
            ((RowSelection)object).setTimeout(queryParameters.getRowSelection().getTimeout());
            queryParameters2 = queryParameters.createCopyUsing((RowSelection)object);
        } else {
            queryParameters2 = queryParameters;
        }
        object = new ArrayList();
        IdentitySet identitySet = new IdentitySet();
        int n = -1;
        block0: for (QueryTranslator queryTranslator : this.translators) {
            List list = queryTranslator.list(sessionImplementor, queryParameters2);
            if (bl) {
                int n2 = queryParameters.getRowSelection().getFirstRow() == null ? 0 : queryParameters.getRowSelection().getFirstRow();
                int n3 = queryParameters.getRowSelection().getMaxRows() == null ? -1 : queryParameters.getRowSelection().getMaxRows();
                for (Object e : list) {
                    if (!identitySet.add(e) || ++n < n2) continue;
                    object.add(e);
                    if (n3 < 0 || n <= n3) continue;
                    break block0;
                }
                continue;
            }
            object.addAll(list);
        }
        return object;
    }

    public Iterator performIterate(QueryParameters queryParameters, EventSource eventSource) throws HibernateException {
        boolean bl;
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Iterate: {0}", (Object)this.getSourceQuery());
            queryParameters.traceParameters(eventSource.getFactory());
        }
        if (this.translators.length == 0) {
            return EmptyIterator.INSTANCE;
        }
        Iterator[] iteratorArray = null;
        boolean bl2 = bl = this.translators.length > 1;
        if (bl) {
            iteratorArray = new Iterator[this.translators.length];
        }
        Iterator iterator = null;
        for (int i = 0; i < this.translators.length; ++i) {
            iterator = this.translators[i].iterate(queryParameters, eventSource);
            if (!bl) continue;
            iteratorArray[i] = iterator;
        }
        return bl ? new JoinedIterator(iteratorArray) : iterator;
    }

    public ScrollableResults performScroll(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Iterate: {0}", (Object)this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        if (this.translators.length != 1) {
            throw new QueryException("implicit polymorphism not supported for scroll() queries");
        }
        if (queryParameters.getRowSelection().definesLimits() && this.translators[0].containsCollectionFetches()) {
            throw new QueryException("firstResult/maxResults not supported in conjunction with scroll() of a query containing collection fetches");
        }
        return this.translators[0].scroll(queryParameters, sessionImplementor);
    }

    public int performExecuteUpdate(QueryParameters queryParameters, SessionImplementor sessionImplementor) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Execute update: {0}", (Object)this.getSourceQuery());
            queryParameters.traceParameters(sessionImplementor.getFactory());
        }
        if (this.translators.length != 1) {
            LOG.splitQueries(this.getSourceQuery(), this.translators.length);
        }
        int n = 0;
        for (QueryTranslator queryTranslator : this.translators) {
            n += queryTranslator.executeUpdate(queryParameters, sessionImplementor);
        }
        return n;
    }

    private ParameterMetadata buildParameterMetadata(ParameterTranslations parameterTranslations, String string) {
        long l = System.currentTimeMillis();
        ParamLocationRecognizer paramLocationRecognizer = ParamLocationRecognizer.parseLocations(string);
        long l2 = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.tracev("HQL param location recognition took {0} mills ({1})", (Object)(l2 - l), (Object)string);
        }
        int n = parameterTranslations.getOrdinalParameterCount();
        int[] nArray = ArrayHelper.toIntArray(paramLocationRecognizer.getOrdinalParameterLocationList());
        if (parameterTranslations.supportsOrdinalParameterMetadata() && nArray.length != n) {
            throw new HibernateException("ordinal parameter mismatch");
        }
        n = nArray.length;
        OrdinalParameterDescriptor[] ordinalParameterDescriptorArray = new OrdinalParameterDescriptor[n];
        for (int i = 1; i <= n; ++i) {
            ordinalParameterDescriptorArray[i - 1] = new OrdinalParameterDescriptor(i, parameterTranslations.supportsOrdinalParameterMetadata() ? parameterTranslations.getOrdinalParameterExpectedType(i) : null, nArray[i - 1]);
        }
        HashMap<String, NamedParameterDescriptor> hashMap = new HashMap<String, NamedParameterDescriptor>();
        Map<String, ParamLocationRecognizer.NamedParameterDescription> map = paramLocationRecognizer.getNamedParameterDescriptionMap();
        for (String string2 : map.keySet()) {
            ParamLocationRecognizer.NamedParameterDescription namedParameterDescription = map.get(string2);
            hashMap.put(string2, new NamedParameterDescriptor(string2, parameterTranslations.getNamedParameterExpectedType(string2), namedParameterDescription.buildPositionsArray(), namedParameterDescription.isJpaStyle()));
        }
        return new ParameterMetadata(ordinalParameterDescriptorArray, hashMap);
    }

    public QueryTranslator[] getTranslators() {
        QueryTranslator[] queryTranslatorArray = new QueryTranslator[this.translators.length];
        System.arraycopy(this.translators, 0, queryTranslatorArray, 0, queryTranslatorArray.length);
        return queryTranslatorArray;
    }

    public Class getDynamicInstantiationResultType() {
        return this.translators[0].getDynamicInstantiationResultType();
    }
}

