/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.BagType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchProfile {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, FetchProfile.class.getName());
    private final String name;
    private Map<String, Fetch> fetches = new HashMap<String, Fetch>();
    private boolean containsJoinFetchedCollection = false;
    private boolean containsJoinFetchedBag = false;
    private Fetch bagJoinFetch;

    public FetchProfile(String string) {
        this.name = string;
    }

    public void addFetch(Association association, String string) {
        this.addFetch(association, Fetch.Style.parse(string));
    }

    public void addFetch(Association association, Fetch.Style style) {
        this.addFetch(new Fetch(association, style));
    }

    public void addFetch(Fetch fetch) {
        String string = fetch.getAssociation().getRole();
        Type type = fetch.getAssociation().getOwner().getPropertyType(fetch.getAssociation().getAssociationPath());
        if (type.isCollectionType()) {
            LOG.tracev("Handling request to add collection fetch [{0}]", (Object)string);
            if (Fetch.Style.JOIN == fetch.getStyle()) {
                if (BagType.class.isInstance(type) && this.containsJoinFetchedCollection) {
                    LOG.containsJoinFetchedCollection(string);
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        LOG.unableToRemoveBagJoinFetch();
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(string, fetch);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Fetch> getFetches() {
        return this.fetches;
    }

    public Fetch getFetchByRole(String string) {
        return this.fetches.get(string);
    }

    public boolean isContainsJoinFetchedCollection() {
        return this.containsJoinFetchedCollection;
    }

    public boolean isContainsJoinFetchedBag() {
        return this.containsJoinFetchedBag;
    }
}

