/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.loading.internal.CollectionLoadContext;
import org.hibernate.engine.loading.internal.EntityLoadContext;
import org.hibernate.engine.loading.internal.LoadingCollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadContexts {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, LoadContexts.class.getName());
    private final PersistenceContext persistenceContext;
    private Map<ResultSet, CollectionLoadContext> collectionLoadContexts;
    private Map<ResultSet, EntityLoadContext> entityLoadContexts;
    private Map<CollectionKey, LoadingCollectionEntry> xrefLoadingCollectionEntries;

    public LoadContexts(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    private SessionImplementor getSession() {
        return this.getPersistenceContext().getSession();
    }

    public void cleanup(ResultSet resultSet) {
        Object object;
        if (this.collectionLoadContexts != null) {
            object = this.collectionLoadContexts.remove(resultSet);
            ((CollectionLoadContext)object).cleanup();
        }
        if (this.entityLoadContexts != null) {
            object = this.entityLoadContexts.remove(resultSet);
            ((EntityLoadContext)object).cleanup();
        }
    }

    public void cleanup() {
        if (this.collectionLoadContexts != null) {
            for (CollectionLoadContext object : this.collectionLoadContexts.values()) {
                LOG.failSafeCollectionsCleanup(object);
                object.cleanup();
            }
            this.collectionLoadContexts.clear();
        }
        if (this.entityLoadContexts != null) {
            for (EntityLoadContext entityLoadContext : this.entityLoadContexts.values()) {
                LOG.failSafeEntitiesCleanup(entityLoadContext);
                entityLoadContext.cleanup();
            }
            this.entityLoadContexts.clear();
        }
    }

    public boolean hasLoadingCollectionEntries() {
        return this.collectionLoadContexts != null && !this.collectionLoadContexts.isEmpty();
    }

    public boolean hasRegisteredLoadingCollectionEntries() {
        return this.xrefLoadingCollectionEntries != null && !this.xrefLoadingCollectionEntries.isEmpty();
    }

    public CollectionLoadContext getCollectionLoadContext(ResultSet resultSet) {
        CollectionLoadContext collectionLoadContext = null;
        if (this.collectionLoadContexts == null) {
            this.collectionLoadContexts = new IdentityHashMap<ResultSet, CollectionLoadContext>(8);
        } else {
            collectionLoadContext = this.collectionLoadContexts.get(resultSet);
        }
        if (collectionLoadContext == null) {
            LOG.tracev("Constructing collection load context for result set [{0}]", (Object)resultSet);
            collectionLoadContext = new CollectionLoadContext(this, resultSet);
            this.collectionLoadContexts.put(resultSet, collectionLoadContext);
        }
        return collectionLoadContext;
    }

    public PersistentCollection locateLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry = this.locateLoadingCollectionEntry(new CollectionKey(collectionPersister, serializable));
        if (loadingCollectionEntry != null) {
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Returning loading collection: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, serializable, this.getSession().getFactory()));
            }
            return loadingCollectionEntry.getCollection();
        }
        return null;
    }

    void registerLoadingCollectionXRef(CollectionKey collectionKey, LoadingCollectionEntry loadingCollectionEntry) {
        if (this.xrefLoadingCollectionEntries == null) {
            this.xrefLoadingCollectionEntries = new HashMap<CollectionKey, LoadingCollectionEntry>();
        }
        this.xrefLoadingCollectionEntries.put(collectionKey, loadingCollectionEntry);
    }

    void unregisterLoadingCollectionXRef(CollectionKey collectionKey) {
        if (!this.hasRegisteredLoadingCollectionEntries()) {
            return;
        }
        this.xrefLoadingCollectionEntries.remove(collectionKey);
    }

    Map getLoadingCollectionXRefs() {
        return this.xrefLoadingCollectionEntries;
    }

    LoadingCollectionEntry locateLoadingCollectionEntry(CollectionKey collectionKey) {
        if (this.xrefLoadingCollectionEntries == null) {
            return null;
        }
        LOG.tracev("Attempting to locate loading collection entry [{0}] in any result-set context", (Object)collectionKey);
        LoadingCollectionEntry loadingCollectionEntry = this.xrefLoadingCollectionEntries.get(collectionKey);
        if (loadingCollectionEntry == null) {
            LOG.tracev("Collection [{0}] not located in load context", (Object)collectionKey);
        } else {
            LOG.tracev("Collection [{0}] located in load context", (Object)collectionKey);
        }
        return loadingCollectionEntry;
    }

    void cleanupCollectionXRefs(Set<CollectionKey> set) {
        for (CollectionKey collectionKey : set) {
            this.xrefLoadingCollectionEntries.remove(collectionKey);
        }
    }

    public EntityLoadContext getEntityLoadContext(ResultSet resultSet) {
        EntityLoadContext entityLoadContext = null;
        if (this.entityLoadContexts == null) {
            this.entityLoadContexts = new IdentityHashMap<ResultSet, EntityLoadContext>(8);
        } else {
            entityLoadContext = this.entityLoadContexts.get(resultSet);
        }
        if (entityLoadContext == null) {
            entityLoadContext = new EntityLoadContext(this, resultSet);
            this.entityLoadContexts.put(resultSet, entityLoadContext);
        }
        return entityLoadContext;
    }
}

