/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.loading.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.entry.CollectionCacheEntry;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.loading.internal.LoadContexts;
import org.hibernate.engine.loading.internal.LoadingCollectionEntry;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class CollectionLoadContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, CollectionLoadContext.class.getName());
    private final LoadContexts loadContexts;
    private final ResultSet resultSet;
    private Set localLoadingCollectionKeys = new HashSet();

    public CollectionLoadContext(LoadContexts loadContexts, ResultSet resultSet) {
        this.loadContexts = loadContexts;
        this.resultSet = resultSet;
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public LoadContexts getLoadContext() {
        return this.loadContexts;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister collectionPersister, Serializable serializable) {
        LoadingCollectionEntry loadingCollectionEntry;
        EntityMode entityMode = collectionPersister.getOwnerEntityPersister().getEntityMetamodel().getEntityMode();
        CollectionKey collectionKey = new CollectionKey(collectionPersister, serializable, entityMode);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Starting attempt to find loading collection [{0}]", (Object)MessageHelper.collectionInfoString(collectionPersister.getRole(), serializable));
        }
        if ((loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey)) == null) {
            PersistentCollection persistentCollection = this.loadContexts.getPersistenceContext().getCollection(collectionKey);
            if (persistentCollection != null) {
                if (persistentCollection.wasInitialized()) {
                    LOG.trace("Collection already initialized; ignoring");
                    return null;
                }
                LOG.trace("Collection not yet initialized; initializing");
            } else {
                boolean bl;
                Object object = this.loadContexts.getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
                boolean bl2 = bl = object != null && this.loadContexts.getPersistenceContext().getEntry(object).getStatus() != Status.LOADING;
                if (bl) {
                    LOG.trace("Owning entity already loaded; ignoring");
                    return null;
                }
                LOG.tracev("Instantiating new collection [key={0}, rs={1}]", (Object)serializable, (Object)this.resultSet);
                persistentCollection = collectionPersister.getCollectionType().instantiate(this.loadContexts.getPersistenceContext().getSession(), collectionPersister, serializable);
            }
            persistentCollection.beforeInitialize(collectionPersister, -1);
            persistentCollection.beginRead();
            this.localLoadingCollectionKeys.add(collectionKey);
            this.loadContexts.registerLoadingCollectionXRef(collectionKey, new LoadingCollectionEntry(this.resultSet, collectionPersister, serializable, persistentCollection));
            return persistentCollection;
        }
        if (loadingCollectionEntry.getResultSet() == this.resultSet) {
            LOG.trace("Found loading collection bound to current result set processing; reading row");
            return loadingCollectionEntry.getCollection();
        }
        LOG.trace("Collection is already being initialized; ignoring row");
        return null;
    }

    public void endLoadingCollections(CollectionPersister collectionPersister) {
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        if (!this.loadContexts.hasLoadingCollectionEntries() && this.localLoadingCollectionKeys.isEmpty()) {
            return;
        }
        ArrayList<LoadingCollectionEntry> arrayList = null;
        Iterator iterator = this.localLoadingCollectionKeys.iterator();
        while (iterator.hasNext()) {
            CollectionKey collectionKey = (CollectionKey)iterator.next();
            LoadingCollectionEntry loadingCollectionEntry = this.loadContexts.locateLoadingCollectionEntry(collectionKey);
            if (loadingCollectionEntry == null) {
                LOG.loadingCollectionKeyNotFound(collectionKey);
                continue;
            }
            if (loadingCollectionEntry.getResultSet() != this.resultSet || loadingCollectionEntry.getPersister() != collectionPersister) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<LoadingCollectionEntry>();
            }
            arrayList.add(loadingCollectionEntry);
            if (loadingCollectionEntry.getCollection().getOwner() == null) {
                sessionImplementor.getPersistenceContext().addUnownedCollection(new CollectionKey(collectionPersister, loadingCollectionEntry.getKey(), collectionPersister.getOwnerEntityPersister().getEntityMetamodel().getEntityMode()), loadingCollectionEntry.getCollection());
            }
            LOG.tracev("Removing collection load entry [{0}]", (Object)loadingCollectionEntry);
            this.loadContexts.unregisterLoadingCollectionXRef(collectionKey);
            iterator.remove();
        }
        this.endLoadingCollections(collectionPersister, arrayList);
        if (this.localLoadingCollectionKeys.isEmpty()) {
            this.loadContexts.cleanup(this.resultSet);
        }
    }

    private void endLoadingCollections(CollectionPersister collectionPersister, List list) {
        boolean bl = LOG.isDebugEnabled();
        if (list == null) {
            if (bl) {
                LOG.debugf("No collections were found in result set for role: %s", (Object)collectionPersister.getRole());
            }
            return;
        }
        int n = list.size();
        if (bl) {
            LOG.debugf("%s collections were found in result set for role: %s", (Object)n, (Object)collectionPersister.getRole());
        }
        for (int i = 0; i < n; ++i) {
            LoadingCollectionEntry loadingCollectionEntry = (LoadingCollectionEntry)list.get(i);
            this.endLoadingCollection(loadingCollectionEntry, collectionPersister);
        }
        if (bl) {
            LOG.debugf("%s collections initialized for role: %s", (Object)n, (Object)collectionPersister.getRole());
        }
    }

    private void endLoadingCollection(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        boolean bl;
        CollectionEntry collectionEntry;
        LOG.tracev("Ending loading collection [{0}]", (Object)loadingCollectionEntry);
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        boolean bl2 = loadingCollectionEntry.getCollection().endRead();
        if (collectionPersister.getCollectionType().hasHolder()) {
            this.getLoadContext().getPersistenceContext().addCollectionHolder(loadingCollectionEntry.getCollection());
        }
        if ((collectionEntry = this.getLoadContext().getPersistenceContext().getCollectionEntry(loadingCollectionEntry.getCollection())) == null) {
            collectionEntry = this.getLoadContext().getPersistenceContext().addInitializedCollection(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey());
        } else {
            collectionEntry.postInitialize(loadingCollectionEntry.getCollection());
        }
        boolean bl3 = bl = bl2 && collectionPersister.hasCache() && sessionImplementor.getCacheMode().isPutEnabled() && !collectionEntry.isDoremove();
        if (bl) {
            this.addCollectionToCache(loadingCollectionEntry, collectionPersister);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Collection fully initialized: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey(), sessionImplementor));
        }
        if (sessionImplementor.getFactory().getStatistics().isStatisticsEnabled()) {
            sessionImplementor.getFactory().getStatisticsImplementor().loadCollection(collectionPersister.getRole());
        }
    }

    private void addCollectionToCache(LoadingCollectionEntry loadingCollectionEntry, CollectionPersister collectionPersister) {
        Object object;
        Object object2;
        Object object3;
        SessionImplementor sessionImplementor = this.getLoadContext().getPersistenceContext().getSession();
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        boolean bl = LOG.isDebugEnabled();
        if (bl) {
            LOG.debugf("Caching collection: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey(), sessionImplementor));
        }
        if (!sessionImplementor.getEnabledFilters().isEmpty() && collectionPersister.isAffectedByEnabledFilters(sessionImplementor)) {
            if (bl) {
                LOG.debug("Refusing to add to cache due to enabled filters");
            }
            return;
        }
        if (collectionPersister.isVersioned()) {
            object3 = this.getLoadContext().getPersistenceContext().getCollectionOwner(loadingCollectionEntry.getKey(), collectionPersister);
            if (object3 == null) {
                if (loadingCollectionEntry.getCollection() != null && (object2 = loadingCollectionEntry.getCollection().getOwner()) != null) {
                    Serializable serializable = collectionPersister.getOwnerEntityPersister().getIdentifier(object2, sessionImplementor);
                    object3 = this.getLoadContext().getPersistenceContext().getCollectionOwner(serializable, collectionPersister);
                }
                if (object3 == null) {
                    throw new HibernateException("Unable to resolve owner of loading collection [" + MessageHelper.collectionInfoString(collectionPersister, loadingCollectionEntry.getCollection(), loadingCollectionEntry.getKey(), sessionImplementor) + "] for second level caching");
                }
            }
            object = this.getLoadContext().getPersistenceContext().getEntry(object3).getVersion();
        } else {
            object = null;
        }
        object3 = new CollectionCacheEntry(loadingCollectionEntry.getCollection(), collectionPersister);
        object2 = sessionImplementor.generateCacheKey(loadingCollectionEntry.getKey(), collectionPersister.getKeyType(), collectionPersister.getRole());
        boolean bl2 = collectionPersister.getCacheAccessStrategy().putFromLoad(object2, collectionPersister.getCacheEntryStructure().structure(object3), sessionImplementor.getTimestamp(), object, sessionFactoryImplementor.getSettings().isMinimalPutsEnabled() && sessionImplementor.getCacheMode() != CacheMode.REFRESH);
        if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(collectionPersister.getCacheAccessStrategy().getRegion().getName());
        }
    }

    void cleanup() {
        if (!this.localLoadingCollectionKeys.isEmpty()) {
            LOG.localLoadingCollectionKeysCount(this.localLoadingCollectionKeys.size());
        }
        this.loadContexts.cleanupCollectionXRefs(this.localLoadingCollectionKeys);
        this.localLoadingCollectionKeys.clear();
    }

    public String toString() {
        return super.toString() + "<rs=" + this.resultSet + ">";
    }
}

