/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.spi;

import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SqlStatementLogger {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, "org.hibernate.SQL");
    private boolean logToStdout;
    private boolean format;

    public SqlStatementLogger() {
        this(false, false);
    }

    public SqlStatementLogger(boolean bl, boolean bl2) {
        this.logToStdout = bl;
        this.format = bl2;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public void setLogToStdout(boolean bl) {
        this.logToStdout = bl;
    }

    public boolean isFormat() {
        return this.format;
    }

    public void setFormat(boolean bl) {
        this.format = bl;
    }

    public void logStatement(String string) {
        this.logStatement(string, FormatStyle.BASIC.getFormatter());
    }

    public void logStatement(String string, Formatter formatter) {
        if (this.format && (this.logToStdout || LOG.isDebugEnabled())) {
            string = formatter.format(string);
        }
        LOG.debug(string);
        if (this.logToStdout) {
            System.out.println("Hibernate: " + string);
        }
    }
}

