/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hibernate.JDBCException;
import org.hibernate.exception.internal.SQLStateConverter;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.exception.spi.ViolatedConstraintNameExtracter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class SqlExceptionHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, SqlExceptionHelper.class.getName());
    public static final String DEFAULT_EXCEPTION_MSG = "SQL Exception";
    public static final String DEFAULT_WARNING_MSG = "SQL Warning";
    public static final SQLExceptionConverter DEFAULT_CONVERTER = new SQLStateConverter(new ViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sQLException) {
            return null;
        }
    });
    private SQLExceptionConverter sqlExceptionConverter;
    public static StandardWarningHandler STANDARD_WARNING_HANDLER = new StandardWarningHandler("SQL Warning");

    public SqlExceptionHelper() {
        this.sqlExceptionConverter = DEFAULT_CONVERTER;
    }

    public SqlExceptionHelper(SQLExceptionConverter sQLExceptionConverter) {
        this.sqlExceptionConverter = sQLExceptionConverter;
    }

    public SQLExceptionConverter getSqlExceptionConverter() {
        return this.sqlExceptionConverter;
    }

    public void setSqlExceptionConverter(SQLExceptionConverter sQLExceptionConverter) {
        this.sqlExceptionConverter = sQLExceptionConverter == null ? DEFAULT_CONVERTER : sQLExceptionConverter;
    }

    public JDBCException convert(SQLException sQLException, String string) {
        return this.convert(sQLException, string, "n/a");
    }

    public JDBCException convert(SQLException sQLException, String string, String string2) {
        this.logExceptions(sQLException, string + " [" + string2 + "]");
        return this.sqlExceptionConverter.convert(sQLException, string, string2);
    }

    public void logExceptions(SQLException sQLException, String string) {
        if (LOG.isEnabled(Logger.Level.ERROR)) {
            if (LOG.isDebugEnabled()) {
                string = StringHelper.isNotEmpty(string) ? string : DEFAULT_EXCEPTION_MSG;
                LOG.debug(string, sQLException);
            }
            boolean bl = LOG.isEnabled(Logger.Level.WARN);
            while (sQLException != null) {
                if (bl) {
                    StringBuilder stringBuilder = new StringBuilder(30).append("SQL Error: ").append(sQLException.getErrorCode()).append(", SQLState: ").append(sQLException.getSQLState());
                    LOG.warn(stringBuilder.toString());
                }
                LOG.error(sQLException.getMessage());
                sQLException = sQLException.getNextException();
            }
        }
    }

    public void walkWarnings(SQLWarning sQLWarning, WarningHandler warningHandler) {
        if (sQLWarning == null || warningHandler.doProcess()) {
            return;
        }
        warningHandler.prepare(sQLWarning);
        while (sQLWarning != null) {
            warningHandler.handleWarning(sQLWarning);
            sQLWarning = sQLWarning.getNextWarning();
        }
    }

    public void logAndClearWarnings(Connection connection) {
        this.handleAndClearWarnings(connection, (WarningHandler)STANDARD_WARNING_HANDLER);
    }

    public void handleAndClearWarnings(Connection connection, WarningHandler warningHandler) {
        try {
            this.walkWarnings(connection.getWarnings(), warningHandler);
        }
        catch (SQLException sQLException) {
            LOG.debug("could not log warnings", sQLException);
        }
        try {
            connection.clearWarnings();
        }
        catch (SQLException sQLException) {
            LOG.debug("could not clear warnings", sQLException);
        }
    }

    public void handleAndClearWarnings(Statement statement, WarningHandler warningHandler) {
        try {
            this.walkWarnings(statement.getWarnings(), warningHandler);
        }
        catch (SQLException sQLException) {
            LOG.debug("could not log warnings", sQLException);
        }
        try {
            statement.clearWarnings();
        }
        catch (SQLException sQLException) {
            LOG.debug("could not clear warnings", sQLException);
        }
    }

    public static class StandardWarningHandler
    extends WarningHandlerLoggingSupport {
        private final String introMessage;

        public StandardWarningHandler(String string) {
            this.introMessage = string;
        }

        public boolean doProcess() {
            return LOG.isEnabled(Logger.Level.WARN);
        }

        public void prepare(SQLWarning sQLWarning) {
            LOG.debug(this.introMessage, sQLWarning);
        }

        protected void logWarning(String string, String string2) {
            LOG.warn(string);
            LOG.warn(string2);
        }
    }

    public static abstract class WarningHandlerLoggingSupport
    implements WarningHandler {
        public final void handleWarning(SQLWarning sQLWarning) {
            StringBuilder stringBuilder = new StringBuilder(30).append("SQL Warning Code: ").append(sQLWarning.getErrorCode()).append(", SQLState: ").append(sQLWarning.getSQLState());
            this.logWarning(stringBuilder.toString(), sQLWarning.getMessage());
        }

        protected abstract void logWarning(String var1, String var2);
    }

    public static interface WarningHandler {
        public boolean doProcess();

        public void prepare(SQLWarning var1);

        public void handleWarning(SQLWarning var1);
    }
}

