/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import org.hibernate.engine.jdbc.internal.TypeInfo;
import org.hibernate.engine.jdbc.internal.TypeNullability;
import org.hibernate.engine.jdbc.internal.TypeSearchability;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoExtracter {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TypeInfoExtracter.class.getName());

    private TypeInfoExtracter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashSet<TypeInfo> extractTypeInfo(DatabaseMetaData databaseMetaData) {
        LinkedHashSet<TypeInfo> linkedHashSet = new LinkedHashSet<TypeInfo>();
        try {
            ResultSet resultSet = databaseMetaData.getTypeInfo();
            try {
                while (resultSet.next()) {
                    linkedHashSet.add(new TypeInfo(resultSet.getString("TYPE_NAME"), resultSet.getInt("DATA_TYPE"), TypeInfoExtracter.interpretCreateParams(resultSet.getString("CREATE_PARAMS")), resultSet.getBoolean("UNSIGNED_ATTRIBUTE"), resultSet.getInt("PRECISION"), resultSet.getShort("MINIMUM_SCALE"), resultSet.getShort("MAXIMUM_SCALE"), resultSet.getBoolean("FIXED_PREC_SCALE"), resultSet.getString("LITERAL_PREFIX"), resultSet.getString("LITERAL_SUFFIX"), resultSet.getBoolean("CASE_SENSITIVE"), TypeSearchability.interpret(resultSet.getShort("SEARCHABLE")), TypeNullability.interpret(resultSet.getShort("NULLABLE"))));
                }
            }
            catch (SQLException sQLException) {
                LOG.unableToAccessTypeInfoResultSet(sQLException.toString());
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    LOG.unableToReleaseTypeInfoResultSet();
                }
            }
        }
        catch (SQLException sQLException) {
            LOG.unableToRetrieveTypeInfoResultSet(sQLException.toString());
        }
        return linkedHashSet;
    }

    private static String[] interpretCreateParams(String string) {
        if (string == null || string.length() == 0) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return string.split(",");
    }
}

