/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.AssertionFailure;
import org.hibernate.ScrollMode;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.jdbc.internal.JdbcCoordinatorImpl;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;

class StatementPreparerImpl
implements StatementPreparer {
    private JdbcCoordinatorImpl jdbcCoordinator;

    StatementPreparerImpl(JdbcCoordinatorImpl jdbcCoordinatorImpl) {
        this.jdbcCoordinator = jdbcCoordinatorImpl;
    }

    protected final Settings settings() {
        return this.jdbcCoordinator.sessionFactory().getSettings();
    }

    protected final Connection connection() {
        return this.logicalConnection().getConnection();
    }

    protected final LogicalConnectionImplementor logicalConnection() {
        return this.jdbcCoordinator.getLogicalConnection();
    }

    protected final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    public Statement createStatement() {
        try {
            Statement statement = this.connection().createStatement();
            this.jdbcCoordinator.register(statement);
            return statement;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not create statement");
        }
    }

    public PreparedStatement prepareStatement(String string) {
        return this.buildPreparedStatementPreparationTemplate(string, false).prepareStatement();
    }

    public PreparedStatement prepareStatement(String string, boolean bl) {
        this.jdbcCoordinator.executeBatch();
        return this.buildPreparedStatementPreparationTemplate(string, bl).prepareStatement();
    }

    private StatementPreparationTemplate buildPreparedStatementPreparationTemplate(String string, final boolean bl) {
        return new StatementPreparationTemplate(string){

            protected PreparedStatement doPrepare() throws SQLException {
                return bl ? StatementPreparerImpl.this.connection().prepareCall(this.sql) : StatementPreparerImpl.this.connection().prepareStatement(this.sql);
            }
        };
    }

    private void checkAutoGeneratedKeysSupportEnabled() {
        if (!this.settings().isGetGeneratedKeysEnabled()) {
            throw new AssertionFailure("getGeneratedKeys() support is not enabled");
        }
    }

    public PreparedStatement prepareStatement(String string, final int n) {
        if (n == 1) {
            this.checkAutoGeneratedKeysSupportEnabled();
        }
        this.jdbcCoordinator.executeBatch();
        return new StatementPreparationTemplate(string){

            public PreparedStatement doPrepare() throws SQLException {
                return StatementPreparerImpl.this.connection().prepareStatement(this.sql, n);
            }
        }.prepareStatement();
    }

    public PreparedStatement prepareStatement(String string, final String[] stringArray) {
        this.checkAutoGeneratedKeysSupportEnabled();
        this.jdbcCoordinator.executeBatch();
        return new StatementPreparationTemplate(string){

            public PreparedStatement doPrepare() throws SQLException {
                return StatementPreparerImpl.this.connection().prepareStatement(this.sql, stringArray);
            }
        }.prepareStatement();
    }

    public PreparedStatement prepareQueryStatement(String string, final boolean bl, final ScrollMode scrollMode) {
        if (scrollMode != null && !scrollMode.equals((Object)ScrollMode.FORWARD_ONLY)) {
            if (!this.settings().isScrollableResultSetsEnabled()) {
                throw new AssertionFailure("scrollable result sets are not enabled");
            }
            PreparedStatement preparedStatement = new QueryStatementPreparationTemplate(string){

                public PreparedStatement doPrepare() throws SQLException {
                    return bl ? StatementPreparerImpl.this.connection().prepareCall(this.sql, scrollMode.toResultSetType(), 1007) : StatementPreparerImpl.this.connection().prepareStatement(this.sql, scrollMode.toResultSetType(), 1007);
                }
            }.prepareStatement();
            this.jdbcCoordinator.registerLastQuery(preparedStatement);
            return preparedStatement;
        }
        PreparedStatement preparedStatement = new QueryStatementPreparationTemplate(string){

            public PreparedStatement doPrepare() throws SQLException {
                return bl ? StatementPreparerImpl.this.connection().prepareCall(this.sql) : StatementPreparerImpl.this.connection().prepareStatement(this.sql);
            }
        }.prepareStatement();
        this.jdbcCoordinator.registerLastQuery(preparedStatement);
        return preparedStatement;
    }

    private void setStatementFetchSize(PreparedStatement preparedStatement) throws SQLException {
        if (this.settings().getJdbcFetchSize() != null) {
            preparedStatement.setFetchSize(this.settings().getJdbcFetchSize());
        }
    }

    private abstract class QueryStatementPreparationTemplate
    extends StatementPreparationTemplate {
        protected QueryStatementPreparationTemplate(String string) {
            super(string);
        }

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            super.postProcess(preparedStatement);
            StatementPreparerImpl.this.setStatementFetchSize(preparedStatement);
        }
    }

    private abstract class StatementPreparationTemplate {
        protected final String sql;

        protected StatementPreparationTemplate(String string) {
            this.sql = StatementPreparerImpl.this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().onPrepareStatement(string);
        }

        public PreparedStatement prepareStatement() {
            try {
                StatementPreparerImpl.this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(this.sql);
                PreparedStatement preparedStatement = this.doPrepare();
                this.setStatementTimeout(preparedStatement);
                this.postProcess(preparedStatement);
                return preparedStatement;
            }
            catch (SQLException sQLException) {
                throw StatementPreparerImpl.this.sqlExceptionHelper().convert(sQLException, "could not prepare statement", this.sql);
            }
        }

        protected abstract PreparedStatement doPrepare() throws SQLException;

        public void postProcess(PreparedStatement preparedStatement) throws SQLException {
            StatementPreparerImpl.this.jdbcCoordinator.register(preparedStatement);
            StatementPreparerImpl.this.logicalConnection().notifyObserversStatementPrepared();
        }

        private void setStatementTimeout(PreparedStatement preparedStatement) throws SQLException {
            int n = StatementPreparerImpl.this.jdbcCoordinator.determineRemainingTransactionTimeOutPeriod();
            if (n > 0) {
                preparedStatement.setQueryTimeout(n);
            }
        }
    }
}

