/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;

public class ResultSetReturnImpl
implements ResultSetReturn {
    private final JdbcCoordinator jdbcCoordinator;

    public ResultSetReturnImpl(JdbcCoordinator jdbcCoordinator) {
        this.jdbcCoordinator = jdbcCoordinator;
    }

    public ResultSet extract(PreparedStatement preparedStatement) {
        if (preparedStatement instanceof CallableStatement) {
            CallableStatement callableStatement = (CallableStatement)preparedStatement;
            return this.extract(callableStatement);
        }
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            this.postExtract(resultSet, preparedStatement);
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not extract ResultSet");
        }
    }

    public ResultSet extract(CallableStatement callableStatement) {
        try {
            ResultSet resultSet = this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getDialect().getResultSet(callableStatement);
            this.postExtract(resultSet, callableStatement);
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not extract ResultSet");
        }
    }

    public ResultSet extract(Statement statement, String string) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(string);
        try {
            ResultSet resultSet = statement.executeQuery(string);
            this.postExtract(resultSet, statement);
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not extract ResultSet");
        }
    }

    public ResultSet execute(PreparedStatement preparedStatement) {
        try {
            if (!preparedStatement.execute()) {
                while (!preparedStatement.getMoreResults() && preparedStatement.getUpdateCount() != -1) {
                }
            }
            ResultSet resultSet = preparedStatement.getResultSet();
            this.postExtract(resultSet, preparedStatement);
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not execute statement");
        }
    }

    public ResultSet execute(Statement statement, String string) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(string);
        try {
            if (!statement.execute(string)) {
                while (!statement.getMoreResults() && statement.getUpdateCount() != -1) {
                }
            }
            ResultSet resultSet = statement.getResultSet();
            this.postExtract(resultSet, statement);
            return resultSet;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not execute statement");
        }
    }

    public int executeUpdate(PreparedStatement preparedStatement) {
        try {
            return preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not execute statement");
        }
    }

    public int executeUpdate(Statement statement, String string) {
        this.jdbcCoordinator.getLogicalConnection().getJdbcServices().getSqlStatementLogger().logStatement(string);
        try {
            return statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "could not execute statement");
        }
    }

    private final SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    private void postExtract(ResultSet resultSet, Statement statement) {
        if (resultSet != null) {
            this.jdbcCoordinator.register(resultSet, statement);
        }
    }
}

