/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.spi.ConnectionObserver;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.NonDurableConnectionObserver;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalConnectionImpl
implements LogicalConnectionImplementor {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, LogicalConnectionImpl.class.getName());
    private transient Connection physicalConnection;
    private final transient ConnectionReleaseMode connectionReleaseMode;
    private final transient JdbcServices jdbcServices;
    private final transient JdbcConnectionAccess jdbcConnectionAccess;
    private final transient List<ConnectionObserver> observers;
    private final boolean isUserSuppliedConnection;
    private boolean isClosed;

    public LogicalConnectionImpl(Connection connection, ConnectionReleaseMode connectionReleaseMode, JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess) {
        this(connectionReleaseMode, jdbcServices, jdbcConnectionAccess, connection != null, false, new ArrayList<ConnectionObserver>());
        this.physicalConnection = connection;
    }

    private LogicalConnectionImpl(ConnectionReleaseMode connectionReleaseMode, JdbcServices jdbcServices, JdbcConnectionAccess jdbcConnectionAccess, boolean bl, boolean bl2, List<ConnectionObserver> list) {
        this.connectionReleaseMode = LogicalConnectionImpl.determineConnectionReleaseMode(jdbcConnectionAccess, bl, connectionReleaseMode);
        this.jdbcServices = jdbcServices;
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.observers = list;
        this.isUserSuppliedConnection = bl;
        this.isClosed = bl2;
    }

    private static ConnectionReleaseMode determineConnectionReleaseMode(JdbcConnectionAccess jdbcConnectionAccess, boolean bl, ConnectionReleaseMode connectionReleaseMode) {
        if (bl) {
            return ConnectionReleaseMode.ON_CLOSE;
        }
        if (connectionReleaseMode == ConnectionReleaseMode.AFTER_STATEMENT && !jdbcConnectionAccess.supportsAggressiveRelease()) {
            LOG.debug("Connection provider reports to not support aggressive release; overriding");
            return ConnectionReleaseMode.AFTER_TRANSACTION;
        }
        return connectionReleaseMode;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public void addObserver(ConnectionObserver connectionObserver) {
        this.observers.add(connectionObserver);
    }

    @Override
    public void removeObserver(ConnectionObserver connectionObserver) {
        this.observers.remove(connectionObserver);
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public boolean isPhysicallyConnected() {
        return this.physicalConnection != null;
    }

    @Override
    public Connection getConnection() throws HibernateException {
        if (this.isClosed) {
            throw new HibernateException("Logical connection is closed");
        }
        if (this.physicalConnection == null) {
            if (this.isUserSuppliedConnection) {
                throw new HibernateException("User-supplied connection was null");
            }
            this.obtainConnection();
        }
        return this.physicalConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection close() {
        LOG.trace("Closing logical connection");
        Connection connection = this.isUserSuppliedConnection ? this.physicalConnection : null;
        try {
            if (!this.isUserSuppliedConnection && this.physicalConnection != null) {
                this.releaseConnection();
            }
            Connection connection2 = connection;
            return connection2;
        }
        finally {
            this.physicalConnection = null;
            this.isClosed = true;
            LOG.trace("Logical connection closed");
            for (ConnectionObserver connectionObserver : this.observers) {
                connectionObserver.logicalConnectionClosed();
            }
            this.observers.clear();
        }
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.connectionReleaseMode;
    }

    @Override
    public void aggressiveRelease() {
        if (this.isUserSuppliedConnection) {
            LOG.debug("Cannot aggressively release user-supplied connection; skipping");
        } else {
            LOG.debug("Aggressively releasing JDBC connection");
            if (this.physicalConnection != null) {
                this.releaseConnection();
            }
        }
    }

    private void obtainConnection() throws JDBCException {
        LOG.debug("Obtaining JDBC connection");
        try {
            this.physicalConnection = this.jdbcConnectionAccess.obtainConnection();
            for (ConnectionObserver connectionObserver : this.observers) {
                connectionObserver.physicalConnectionObtained(this.physicalConnection);
            }
            LOG.debug("Obtained JDBC connection");
        }
        catch (SQLException sQLException) {
            throw this.getJdbcServices().getSqlExceptionHelper().convert(sQLException, "Could not open connection");
        }
    }

    @Override
    public void releaseConnection() throws JDBCException {
        LOG.debug("Releasing JDBC connection");
        if (this.physicalConnection == null) {
            return;
        }
        try {
            if (!this.physicalConnection.isClosed()) {
                this.getJdbcServices().getSqlExceptionHelper().logAndClearWarnings(this.physicalConnection);
            }
            if (!this.isUserSuppliedConnection) {
                this.jdbcConnectionAccess.releaseConnection(this.physicalConnection);
            }
        }
        catch (SQLException sQLException) {
            throw this.getJdbcServices().getSqlExceptionHelper().convert(sQLException, "Could not close connection");
        }
        finally {
            this.physicalConnection = null;
        }
        LOG.debug("Released JDBC connection");
        for (ConnectionObserver connectionObserver : this.observers) {
            connectionObserver.physicalConnectionReleased();
        }
        this.releaseNonDurableObservers();
    }

    private void releaseNonDurableObservers() {
        Iterator<ConnectionObserver> iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            if (!NonDurableConnectionObserver.class.isInstance(iterator.next())) continue;
            iterator.remove();
        }
    }

    @Override
    public Connection manualDisconnect() {
        if (this.isClosed) {
            throw new IllegalStateException("cannot manually disconnect because logical connection is already closed");
        }
        Connection connection = this.physicalConnection;
        this.releaseConnection();
        return connection;
    }

    @Override
    public void manualReconnect(Connection connection) {
        if (this.isClosed) {
            throw new IllegalStateException("cannot manually reconnect because logical connection is already closed");
        }
        if (!this.isUserSuppliedConnection) {
            throw new IllegalStateException("cannot manually reconnect unless Connection was originally supplied");
        }
        if (connection == null) {
            throw new IllegalArgumentException("cannot reconnect a null user-supplied connection");
        }
        if (connection == this.physicalConnection) {
            LOG.debug("reconnecting the same connection that is already connected; should this connection have been disconnected?");
        } else if (this.physicalConnection != null) {
            throw new IllegalArgumentException("cannot reconnect to a new user-supplied connection because currently connected; must disconnect before reconnecting.");
        }
        this.physicalConnection = connection;
        LOG.debug("Reconnected JDBC connection");
    }

    @Override
    public boolean isAutoCommit() {
        if (!this.isOpen() || !this.isPhysicallyConnected()) {
            return true;
        }
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException sQLException) {
            throw this.jdbcServices.getSqlExceptionHelper().convert(sQLException, "could not inspect JDBC autocommit mode");
        }
    }

    @Override
    public boolean isUserSuppliedConnection() {
        return this.isUserSuppliedConnection;
    }

    @Override
    public void notifyObserversStatementPrepared() {
        for (ConnectionObserver connectionObserver : this.observers) {
            connectionObserver.statementPrepared();
        }
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeBoolean(this.isUserSuppliedConnection);
        objectOutputStream.writeBoolean(this.isClosed);
        ArrayList<ConnectionObserver> arrayList = new ArrayList<ConnectionObserver>();
        for (ConnectionObserver connectionObserver : this.observers) {
            if (NonDurableConnectionObserver.class.isInstance(connectionObserver)) continue;
            arrayList.add(connectionObserver);
        }
        objectOutputStream.writeInt(arrayList.size());
        for (ConnectionObserver connectionObserver : arrayList) {
            objectOutputStream.writeObject(connectionObserver);
        }
    }

    public static LogicalConnectionImpl deserialize(ObjectInputStream objectInputStream, TransactionContext transactionContext) throws IOException, ClassNotFoundException {
        boolean bl = objectInputStream.readBoolean();
        boolean bl2 = objectInputStream.readBoolean();
        int n = objectInputStream.readInt();
        List<ConnectionObserver> list = CollectionHelper.arrayList(n);
        for (int i = 0; i < n; ++i) {
            list.add((ConnectionObserver)objectInputStream.readObject());
        }
        return new LogicalConnectionImpl(transactionContext.getConnectionReleaseMode(), transactionContext.getTransactionEnvironment().getJdbcServices(), transactionContext.getJdbcConnectionAccess(), bl, bl2, list);
    }
}

