/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.engine.jdbc.ContextualLobCreator;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.jboss.logging.Logger;

public class LobCreatorBuilder {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, LobCreatorBuilder.class.getName());
    private boolean useContextualLobCreation;
    private static final Class[] NO_ARG_SIG = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    public LobCreatorBuilder(Map map, Connection connection) {
        this.useContextualLobCreation = LobCreatorBuilder.useContextualLobCreation(map, connection);
    }

    private static boolean useContextualLobCreation(Map map, Connection connection) {
        block11: {
            boolean bl = ConfigurationHelper.getBoolean("hibernate.jdbc.lob.non_contextual_creation", map);
            if (bl) {
                LOG.disablingContextualLOBCreation("hibernate.jdbc.lob.non_contextual_creation");
                return false;
            }
            if (connection == null) {
                LOG.disablingContextualLOBCreationSinceConnectionNull();
                return false;
            }
            try {
                Object object;
                try {
                    object = connection.getMetaData();
                    if (object.getJDBCMajorVersion() < 4) {
                        LOG.disablingContextualLOBCreationSinceOldJdbcVersion(object.getJDBCMajorVersion());
                        return false;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                object = Connection.class;
                Method method = ((Class)object).getMethod("createClob", NO_ARG_SIG);
                if (!method.getDeclaringClass().equals(Connection.class)) break block11;
                try {
                    Object object2 = method.invoke((Object)connection, NO_ARGS);
                    try {
                        Method method2 = object2.getClass().getMethod("free", NO_ARG_SIG);
                        method2.invoke(object2, NO_ARGS);
                    }
                    catch (Throwable throwable) {
                        LOG.tracef("Unable to free CLOB created to test createClob() implementation : %s", (Object)throwable);
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    LOG.disablingContextualLOBCreationSinceCreateClobFailed(throwable);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return false;
    }

    public LobCreator buildLobCreator(LobCreationContext lobCreationContext) {
        return this.useContextualLobCreation ? new ContextualLobCreator(lobCreationContext) : NonContextualLobCreator.INSTANCE;
    }
}

