/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.internal.LobCreatorBuilder;
import org.hibernate.engine.jdbc.internal.ResultSetWrapperImpl;
import org.hibernate.engine.jdbc.internal.TypeInfo;
import org.hibernate.engine.jdbc.internal.TypeInfoExtracter;
import org.hibernate.engine.jdbc.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.ResultSetWrapper;
import org.hibernate.engine.jdbc.spi.SchemaNameResolver;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.exception.internal.SQLExceptionTypeDelegate;
import org.hibernate.exception.internal.SQLStateConversionDelegate;
import org.hibernate.exception.internal.StandardSQLExceptionConverter;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.service.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcServicesImpl
implements JdbcServices,
ServiceRegistryAwareService,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcServicesImpl.class.getName());
    private ServiceRegistryImplementor serviceRegistry;
    private Dialect dialect;
    private ConnectionProvider connectionProvider;
    private SqlStatementLogger sqlStatementLogger;
    private SqlExceptionHelper sqlExceptionHelper;
    private ExtractedDatabaseMetaData extractedMetaDataSupport;
    private LobCreatorBuilder lobCreatorBuilder;
    public static final String SCHEMA_NAME_RESOLVER = "hibernate.schema_name_resolver";

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.serviceRegistry = serviceRegistryImplementor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(Map map) {
        Object object;
        JdbcConnectionAccess jdbcConnectionAccess = this.buildJdbcConnectionAccess(map);
        DialectFactory dialectFactory = this.serviceRegistry.getService(DialectFactory.class);
        Dialect dialect = null;
        LobCreatorBuilder lobCreatorBuilder = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        String string = "";
        int n = -1;
        boolean bl6 = false;
        String string2 = null;
        String string3 = null;
        LinkedHashSet<TypeInfo> linkedHashSet = new LinkedHashSet<TypeInfo>();
        boolean bl7 = ConfigurationHelper.getBoolean("hibernate.temp.use_jdbc_metadata_defaults", map, true);
        if (bl7) {
            try {
                Connection connection = jdbcConnectionAccess.obtainConnection();
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (LOG.isDebugEnabled()) {
                        LOG.debugf("Database ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseProductVersion(), databaseMetaData.getDatabaseMajorVersion(), databaseMetaData.getDatabaseMinorVersion());
                        LOG.debugf("Driver ->\n       name : %s\n    version : %s\n      major : %s\n      minor : %s", databaseMetaData.getDriverName(), databaseMetaData.getDriverVersion(), databaseMetaData.getDriverMajorVersion(), databaseMetaData.getDriverMinorVersion());
                        LOG.debugf("JDBC version : %s.%s", (Object)databaseMetaData.getJDBCMajorVersion(), (Object)databaseMetaData.getJDBCMinorVersion());
                    }
                    bl = databaseMetaData.supportsResultSetType(1004);
                    bl3 = databaseMetaData.supportsBatchUpdates();
                    bl4 = databaseMetaData.dataDefinitionCausesTransactionCommit();
                    bl5 = !databaseMetaData.dataDefinitionIgnoredInTransactions();
                    bl2 = databaseMetaData.supportsGetGeneratedKeys();
                    string = databaseMetaData.getSQLKeywords();
                    n = databaseMetaData.getSQLStateType();
                    bl6 = databaseMetaData.locatorsUpdateCopy();
                    linkedHashSet.addAll(TypeInfoExtracter.extractTypeInfo(databaseMetaData));
                    dialect = dialectFactory.buildDialect(map, connection);
                    string2 = connection.getCatalog();
                    object = this.determineExplicitSchemaNameResolver(map);
                    if (object == null) {
                        // empty if block
                    }
                    if (object != null) {
                        string3 = object.resolveSchemaName(connection);
                    }
                    lobCreatorBuilder = new LobCreatorBuilder(map, connection);
                }
                catch (SQLException sQLException) {
                    LOG.unableToObtainConnectionMetadata(sQLException.getMessage());
                }
                finally {
                    if (connection != null) {
                        jdbcConnectionAccess.releaseConnection(connection);
                    }
                }
            }
            catch (SQLException sQLException) {
                LOG.unableToObtainConnectionToQueryMetadata(sQLException.getMessage());
                dialect = dialectFactory.buildDialect(map, null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                dialect = dialectFactory.buildDialect(map, null);
            }
        } else {
            dialect = dialectFactory.buildDialect(map, null);
        }
        boolean bl8 = ConfigurationHelper.getBoolean("hibernate.show_sql", map, false);
        boolean bl9 = ConfigurationHelper.getBoolean("hibernate.format_sql", map, false);
        this.dialect = dialect;
        this.lobCreatorBuilder = lobCreatorBuilder == null ? new LobCreatorBuilder(map, null) : lobCreatorBuilder;
        this.sqlStatementLogger = new SqlStatementLogger(bl8, bl9);
        this.extractedMetaDataSupport = new ExtractedDatabaseMetaDataImpl(bl, bl2, bl3, bl5, bl4, this.parseKeywords(string), this.parseSQLStateType(n), bl6, string3, string2, linkedHashSet);
        object = dialect.buildSQLExceptionConverter();
        if (object == null) {
            StandardSQLExceptionConverter standardSQLExceptionConverter = new StandardSQLExceptionConverter();
            object = standardSQLExceptionConverter;
            standardSQLExceptionConverter.addDelegate(dialect.buildSQLExceptionConversionDelegate());
            standardSQLExceptionConverter.addDelegate(new SQLExceptionTypeDelegate(dialect));
            standardSQLExceptionConverter.addDelegate(new SQLStateConversionDelegate(dialect));
        }
        this.sqlExceptionHelper = new SqlExceptionHelper((SQLExceptionConverter)object);
    }

    private JdbcConnectionAccess buildJdbcConnectionAccess(Map map) {
        MultiTenancyStrategy multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(map);
        if (MultiTenancyStrategy.NONE == multiTenancyStrategy) {
            this.connectionProvider = this.serviceRegistry.getService(ConnectionProvider.class);
            return new ConnectionProviderJdbcConnectionAccess(this.connectionProvider);
        }
        this.connectionProvider = null;
        MultiTenantConnectionProvider multiTenantConnectionProvider = this.serviceRegistry.getService(MultiTenantConnectionProvider.class);
        return new MultiTenantConnectionProviderJdbcConnectionAccess(multiTenantConnectionProvider);
    }

    private SchemaNameResolver determineExplicitSchemaNameResolver(Map map) {
        Object v = map.get(SCHEMA_NAME_RESOLVER);
        if (SchemaNameResolver.class.isInstance(v)) {
            return (SchemaNameResolver)v;
        }
        String string = (String)v;
        if (string != null) {
            try {
                Class clazz = ReflectHelper.classForName(string, this.getClass());
                return (SchemaNameResolver)ReflectHelper.getDefaultConstructor(clazz).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                LOG.unableToLocateConfiguredSchemaNameResolver(string, classNotFoundException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(string, invocationTargetException.getTargetException().toString());
            }
            catch (Exception exception) {
                LOG.unableToInstantiateConfiguredSchemaNameResolver(string, exception.toString());
            }
        }
        return null;
    }

    private Set<String> parseKeywords(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(string.split(",")));
        return hashSet;
    }

    private ExtractedDatabaseMetaData.SQLStateType parseSQLStateType(int n) {
        switch (n) {
            case 2: {
                return ExtractedDatabaseMetaData.SQLStateType.SQL99;
            }
            case 1: {
                return ExtractedDatabaseMetaData.SQLStateType.XOpen;
            }
        }
        return ExtractedDatabaseMetaData.SQLStateType.UNKOWN;
    }

    @Override
    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public SqlStatementLogger getSqlStatementLogger() {
        return this.sqlStatementLogger;
    }

    @Override
    public SqlExceptionHelper getSqlExceptionHelper() {
        return this.sqlExceptionHelper;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public ExtractedDatabaseMetaData getExtractedMetaDataSupport() {
        return this.extractedMetaDataSupport;
    }

    @Override
    public LobCreator getLobCreator(LobCreationContext lobCreationContext) {
        return this.lobCreatorBuilder.buildLobCreator(lobCreationContext);
    }

    @Override
    public ResultSetWrapper getResultSetWrapper() {
        return ResultSetWrapperImpl.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExtractedDatabaseMetaDataImpl
    implements ExtractedDatabaseMetaData {
        private final boolean supportsScrollableResults;
        private final boolean supportsGetGeneratedKeys;
        private final boolean supportsBatchUpdates;
        private final boolean supportsDataDefinitionInTransaction;
        private final boolean doesDataDefinitionCauseTransactionCommit;
        private final Set<String> extraKeywords;
        private final ExtractedDatabaseMetaData.SQLStateType sqlStateType;
        private final boolean lobLocatorUpdateCopy;
        private final String connectionSchemaName;
        private final String connectionCatalogName;
        private final LinkedHashSet<TypeInfo> typeInfoSet;

        private ExtractedDatabaseMetaDataImpl(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Set<String> set, ExtractedDatabaseMetaData.SQLStateType sQLStateType, boolean bl6, String string, String string2, LinkedHashSet<TypeInfo> linkedHashSet) {
            this.supportsScrollableResults = bl;
            this.supportsGetGeneratedKeys = bl2;
            this.supportsBatchUpdates = bl3;
            this.supportsDataDefinitionInTransaction = bl4;
            this.doesDataDefinitionCauseTransactionCommit = bl5;
            this.extraKeywords = set;
            this.sqlStateType = sQLStateType;
            this.lobLocatorUpdateCopy = bl6;
            this.connectionSchemaName = string;
            this.connectionCatalogName = string2;
            this.typeInfoSet = linkedHashSet;
        }

        @Override
        public boolean supportsScrollableResults() {
            return this.supportsScrollableResults;
        }

        @Override
        public boolean supportsGetGeneratedKeys() {
            return this.supportsGetGeneratedKeys;
        }

        @Override
        public boolean supportsBatchUpdates() {
            return this.supportsBatchUpdates;
        }

        @Override
        public boolean supportsDataDefinitionInTransaction() {
            return this.supportsDataDefinitionInTransaction;
        }

        @Override
        public boolean doesDataDefinitionCauseTransactionCommit() {
            return this.doesDataDefinitionCauseTransactionCommit;
        }

        @Override
        public Set<String> getExtraKeywords() {
            return this.extraKeywords;
        }

        @Override
        public ExtractedDatabaseMetaData.SQLStateType getSqlStateType() {
            return this.sqlStateType;
        }

        @Override
        public boolean doesLobLocatorUpdateCopy() {
            return this.lobLocatorUpdateCopy;
        }

        @Override
        public String getConnectionSchemaName() {
            return this.connectionSchemaName;
        }

        @Override
        public String getConnectionCatalogName() {
            return this.connectionCatalogName;
        }

        @Override
        public LinkedHashSet<TypeInfo> getTypeInfoSet() {
            return this.typeInfoSet;
        }
    }

    private static class MultiTenantConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final MultiTenantConnectionProvider connectionProvider;

        public MultiTenantConnectionProviderJdbcConnectionAccess(MultiTenantConnectionProvider multiTenantConnectionProvider) {
            this.connectionProvider = multiTenantConnectionProvider;
        }

        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getAnyConnection();
        }

        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.releaseAnyConnection(connection);
        }

        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class ConnectionProviderJdbcConnectionAccess
    implements JdbcConnectionAccess {
        private final ConnectionProvider connectionProvider;

        public ConnectionProviderJdbcConnectionAccess(ConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public Connection obtainConnection() throws SQLException {
            return this.connectionProvider.getConnection();
        }

        public void releaseConnection(Connection connection) throws SQLException {
            this.connectionProvider.closeConnection(connection);
        }

        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

