/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.internal.LogicalConnectionImpl;
import org.hibernate.engine.jdbc.internal.ResultSetReturnImpl;
import org.hibernate.engine.jdbc.internal.StatementPreparerImpl;
import org.hibernate.engine.jdbc.spi.InvalidatableWrapper;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcWrapper;
import org.hibernate.engine.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.engine.jdbc.spi.ResultSetReturn;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.StatementPreparer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.TransactionCoordinatorImpl;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcCoordinatorImpl
implements JdbcCoordinator {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, JdbcCoordinatorImpl.class.getName());
    private transient TransactionCoordinator transactionCoordinator;
    private final transient LogicalConnectionImpl logicalConnection;
    private transient Batch currentBatch;
    private transient long transactionTimeOutInstant = -1L;
    private final HashMap<Statement, Set<ResultSet>> xref = new HashMap();
    private final Set<ResultSet> unassociatedResultSets = new HashSet<ResultSet>();
    private final SqlExceptionHelper exceptionHelper;
    private Statement lastQuery;
    private boolean releasesEnabled = true;
    private int flushDepth = 0;
    private transient StatementPreparer statementPreparer;
    private transient ResultSetReturn resultSetExtractor;

    public JdbcCoordinatorImpl(Connection connection, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = new LogicalConnectionImpl(connection, transactionCoordinator.getTransactionContext().getConnectionReleaseMode(), transactionCoordinator.getTransactionContext().getTransactionEnvironment().getJdbcServices(), transactionCoordinator.getTransactionContext().getJdbcConnectionAccess());
        this.exceptionHelper = this.logicalConnection.getJdbcServices().getSqlExceptionHelper();
    }

    public JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnectionImpl, TransactionCoordinator transactionCoordinator) {
        this.transactionCoordinator = transactionCoordinator;
        this.logicalConnection = logicalConnectionImpl;
        this.exceptionHelper = logicalConnectionImpl.getJdbcServices().getSqlExceptionHelper();
    }

    private JdbcCoordinatorImpl(LogicalConnectionImpl logicalConnectionImpl) {
        this.logicalConnection = logicalConnectionImpl;
        this.exceptionHelper = logicalConnectionImpl.getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public TransactionCoordinator getTransactionCoordinator() {
        return this.transactionCoordinator;
    }

    @Override
    public LogicalConnectionImplementor getLogicalConnection() {
        return this.logicalConnection;
    }

    protected TransactionEnvironment transactionEnvironment() {
        return this.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment();
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.transactionEnvironment().getSessionFactory();
    }

    protected BatchBuilder batchBuilder() {
        return this.sessionFactory().getServiceRegistry().getService(BatchBuilder.class);
    }

    public SqlExceptionHelper sqlExceptionHelper() {
        return this.transactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    @Override
    public void flushBeginning() {
        if (this.flushDepth == 0) {
            this.releasesEnabled = false;
        }
        ++this.flushDepth;
    }

    @Override
    public void flushEnding() {
        --this.flushDepth;
        if (this.flushDepth < 0) {
            throw new HibernateException("Mismatched flush handling");
        }
        if (this.flushDepth == 0) {
            this.releasesEnabled = true;
        }
        this.afterStatementExecution();
    }

    @Override
    public Connection close() {
        LOG.tracev("Closing JDBC container [{0}]", (Object)this);
        if (this.currentBatch != null) {
            LOG.closingUnreleasedBatch();
            this.currentBatch.release();
        }
        this.cleanup();
        return this.logicalConnection.close();
    }

    @Override
    public Batch getBatch(BatchKey batchKey) {
        if (this.currentBatch != null) {
            if (this.currentBatch.getKey().equals(batchKey)) {
                return this.currentBatch;
            }
            this.currentBatch.execute();
            this.currentBatch.release();
        }
        this.currentBatch = this.batchBuilder().buildBatch(batchKey, this);
        return this.currentBatch;
    }

    @Override
    public void executeBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.execute();
            this.currentBatch.release();
        }
    }

    @Override
    public void abortBatch() {
        if (this.currentBatch != null) {
            this.currentBatch.release();
        }
    }

    @Override
    public StatementPreparer getStatementPreparer() {
        if (this.statementPreparer == null) {
            this.statementPreparer = new StatementPreparerImpl(this);
        }
        return this.statementPreparer;
    }

    @Override
    public ResultSetReturn getResultSetReturn() {
        if (this.resultSetExtractor == null) {
            this.resultSetExtractor = new ResultSetReturnImpl(this);
        }
        return this.resultSetExtractor;
    }

    @Override
    public void setTransactionTimeOut(int n) {
        this.transactionTimeOutInstant = System.currentTimeMillis() + (long)(n * 1000);
    }

    @Override
    public int determineRemainingTransactionTimeOutPeriod() {
        if (this.transactionTimeOutInstant < 0L) {
            return -1;
        }
        int n = (int)((this.transactionTimeOutInstant - System.currentTimeMillis()) / 1000L);
        if (n <= 0) {
            throw new TransactionException("transaction timeout expired");
        }
        return n;
    }

    @Override
    public void afterStatementExecution() {
        LOG.tracev("Starting after statement execution processing [{0}]", (Object)this.connectionReleaseMode());
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT) {
            if (!this.releasesEnabled) {
                LOG.debug("Skipping aggressive release due to manual disabling");
                return;
            }
            if (this.hasRegisteredResources()) {
                LOG.debug("Skipping aggressive release due to registered resources");
                return;
            }
            this.getLogicalConnection().releaseConnection();
        }
    }

    @Override
    public void afterTransaction() {
        this.transactionTimeOutInstant = -1L;
        if (this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_STATEMENT || this.connectionReleaseMode() == ConnectionReleaseMode.AFTER_TRANSACTION) {
            if (this.hasRegisteredResources()) {
                LOG.forcingContainerResourceCleanup();
                this.releaseResources();
            }
            this.getLogicalConnection().aggressiveRelease();
        }
    }

    private ConnectionReleaseMode connectionReleaseMode() {
        return this.getLogicalConnection().getConnectionReleaseMode();
    }

    @Override
    public <T> T coordinateWork(WorkExecutorVisitable<T> workExecutorVisitable) {
        Connection connection = this.getLogicalConnection().getConnection();
        try {
            T t = workExecutorVisitable.accept(new WorkExecutor(), connection);
            this.afterStatementExecution();
            return t;
        }
        catch (SQLException sQLException) {
            throw this.sqlExceptionHelper().convert(sQLException, "error executing work");
        }
    }

    @Override
    public boolean isReadyForSerialization() {
        return this.getLogicalConnection().isUserSuppliedConnection() ? !this.getLogicalConnection().isPhysicallyConnected() : !this.hasRegisteredResources();
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        if (!this.isReadyForSerialization()) {
            throw new HibernateException("Cannot serialize Session while connected");
        }
        this.logicalConnection.serialize(objectOutputStream);
    }

    public static JdbcCoordinatorImpl deserialize(ObjectInputStream objectInputStream, TransactionContext transactionContext) throws IOException, ClassNotFoundException {
        return new JdbcCoordinatorImpl(LogicalConnectionImpl.deserialize(objectInputStream, transactionContext));
    }

    public void afterDeserialize(TransactionCoordinatorImpl transactionCoordinatorImpl) {
        this.transactionCoordinator = transactionCoordinatorImpl;
    }

    @Override
    public void register(Statement statement) {
        LOG.tracev("Registering statement [{0}]", (Object)statement);
        if (this.xref.containsKey(statement)) {
            throw new HibernateException("statement already registered with JDBCContainer");
        }
        this.xref.put(statement, null);
    }

    @Override
    public void registerLastQuery(Statement statement) {
        LOG.tracev("Registering last query statement [{0}]", (Object)statement);
        if (statement instanceof JdbcWrapper) {
            JdbcWrapper jdbcWrapper = (JdbcWrapper)((Object)statement);
            this.registerLastQuery((Statement)jdbcWrapper.getWrappedObject());
            return;
        }
        this.lastQuery = statement;
    }

    @Override
    public void cancelLastQuery() {
        try {
            if (this.lastQuery != null) {
                this.lastQuery.cancel();
            }
        }
        catch (SQLException sQLException) {
            throw this.exceptionHelper.convert(sQLException, "Cannot cancel query");
        }
        finally {
            this.lastQuery = null;
        }
    }

    @Override
    public void release(Statement statement) {
        LOG.tracev("Releasing statement [{0}]", (Object)statement);
        Set<ResultSet> set = this.xref.get(statement);
        if (set != null) {
            for (ResultSet resultSet : set) {
                this.close(resultSet);
            }
            set.clear();
        }
        this.xref.remove(statement);
        this.close(statement);
        this.afterStatementExecution();
    }

    @Override
    public void register(ResultSet resultSet, Statement statement) {
        LOG.tracev("Registering result set [{0}]", (Object)resultSet);
        if (statement == null) {
            try {
                statement = resultSet.getStatement();
            }
            catch (SQLException sQLException) {
                throw this.exceptionHelper.convert(sQLException, "unable to access statement from resultset");
            }
        }
        if (statement != null) {
            Set<ResultSet> set;
            if (LOG.isEnabled(Logger.Level.DEBUG) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((set = this.xref.get(statement)) == null) {
                set = new HashSet<ResultSet>();
                this.xref.put(statement, set);
            }
            set.add(resultSet);
        } else {
            this.unassociatedResultSets.add(resultSet);
        }
    }

    @Override
    public void release(ResultSet resultSet) {
        Statement statement;
        LOG.tracev("Releasing result set [{0}]", (Object)resultSet);
        try {
            statement = resultSet.getStatement();
        }
        catch (SQLException sQLException) {
            throw this.exceptionHelper.convert(sQLException, "unable to access statement from resultset");
        }
        if (statement != null) {
            Set<ResultSet> set;
            if (LOG.isEnabled(Logger.Level.DEBUG) && !this.xref.containsKey(statement)) {
                LOG.unregisteredStatement();
            }
            if ((set = this.xref.get(statement)) != null) {
                set.remove(resultSet);
                if (set.isEmpty()) {
                    this.xref.remove(statement);
                }
            }
        } else {
            boolean bl = this.unassociatedResultSets.remove(resultSet);
            if (!bl) {
                LOG.unregisteredResultSetWithoutStatement();
            }
        }
        this.close(resultSet);
    }

    @Override
    public boolean hasRegisteredResources() {
        return !this.xref.isEmpty() || !this.unassociatedResultSets.isEmpty();
    }

    @Override
    public void releaseResources() {
        LOG.tracev("Releasing JDBC container resources [{0}]", (Object)this);
        this.cleanup();
    }

    @Override
    public void enableReleases() {
        this.releasesEnabled = true;
    }

    @Override
    public void disableReleases() {
        this.releasesEnabled = false;
    }

    private void cleanup() {
        for (Map.Entry<Statement, Set<ResultSet>> entry : this.xref.entrySet()) {
            if (entry.getValue() != null) {
                this.closeAll(entry.getValue());
            }
            this.close(entry.getKey());
        }
        this.xref.clear();
        this.closeAll(this.unassociatedResultSets);
    }

    protected void closeAll(Set<ResultSet> set) {
        for (ResultSet resultSet : set) {
            this.close(resultSet);
        }
        set.clear();
    }

    protected void close(Statement statement) {
        LOG.tracev("Closing prepared statement [{0}]", (Object)statement);
        if (statement instanceof InvalidatableWrapper) {
            InvalidatableWrapper invalidatableWrapper = (InvalidatableWrapper)((Object)statement);
            this.close((Statement)invalidatableWrapper.getWrappedObject());
            invalidatableWrapper.invalidate();
            return;
        }
        try {
            try {
                if (statement.getMaxRows() != 0) {
                    statement.setMaxRows(0);
                }
                if (statement.getQueryTimeout() != 0) {
                    statement.setQueryTimeout(0);
                }
            }
            catch (SQLException sQLException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Exception clearing maxRows/queryTimeout [%s]", (Object)sQLException.getMessage());
                }
                return;
            }
            statement.close();
            if (this.lastQuery == statement) {
                this.lastQuery = null;
            }
        }
        catch (SQLException sQLException) {
            LOG.debugf("Unable to release JDBC statement [%s]", (Object)sQLException.getMessage());
        }
        catch (Exception exception) {
            LOG.debugf("Unable to release JDBC statement [%s]", (Object)exception.getMessage());
        }
    }

    protected void close(ResultSet resultSet) {
        LOG.tracev("Closing result set [{0}]", (Object)resultSet);
        if (resultSet instanceof InvalidatableWrapper) {
            InvalidatableWrapper invalidatableWrapper = (InvalidatableWrapper)((Object)resultSet);
            this.close((ResultSet)invalidatableWrapper.getWrappedObject());
            invalidatableWrapper.invalidate();
            return;
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            LOG.debugf("Unable to release JDBC result set [%s]", (Object)sQLException.getMessage());
        }
        catch (Exception exception) {
            LOG.debugf("Unable to release JDBC result set [%s]", (Object)exception.getMessage());
        }
    }
}

