/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.util.StringTokenizer;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.StringHelper;

public class DDLFormatterImpl
implements Formatter {
    public String format(String string) {
        if (StringHelper.isEmpty(string)) {
            return string;
        }
        if (string.toLowerCase().startsWith("create table")) {
            return this.formatCreateTable(string);
        }
        if (string.toLowerCase().startsWith("alter table")) {
            return this.formatAlterTable(string);
        }
        if (string.toLowerCase().startsWith("comment on")) {
            return this.formatCommentOn(string);
        }
        return "\n    " + string;
    }

    private String formatCommentOn(String string) {
        StringBuilder stringBuilder = new StringBuilder(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " '[]\"", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuilder.append(string2);
            if (DDLFormatterImpl.isQuote(string2)) {
                bl = !bl;
                continue;
            }
            if (bl || !"is".equals(string2)) continue;
            stringBuilder.append("\n       ");
        }
        return stringBuilder.toString();
    }

    private String formatAlterTable(String string) {
        StringBuilder stringBuilder = new StringBuilder(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(string, " (,)'[]\"", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (DDLFormatterImpl.isQuote(string2)) {
                bl = !bl;
            } else if (!bl && DDLFormatterImpl.isBreak(string2)) {
                stringBuilder.append("\n        ");
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private String formatCreateTable(String string) {
        StringBuilder stringBuilder = new StringBuilder(60).append("\n    ");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)'[]\"", true);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (DDLFormatterImpl.isQuote(string2)) {
                bl = !bl;
                stringBuilder.append(string2);
                continue;
            }
            if (bl) {
                stringBuilder.append(string2);
                continue;
            }
            if (")".equals(string2) && --n == 0) {
                stringBuilder.append("\n    ");
            }
            stringBuilder.append(string2);
            if (",".equals(string2) && n == 1) {
                stringBuilder.append("\n       ");
            }
            if (!"(".equals(string2) || ++n != 1) continue;
            stringBuilder.append("\n        ");
        }
        return stringBuilder.toString();
    }

    private static boolean isBreak(String string) {
        return "drop".equals(string) || "add".equals(string) || "references".equals(string) || "foreign".equals(string) || "on".equals(string);
    }

    private static boolean isQuote(String string) {
        return "\"".equals(string) || "`".equals(string) || "]".equals(string) || "[".equals(string) || "'".equals(string);
    }
}

