/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.hibernate.engine.jdbc.CharacterStream;
import org.hibernate.type.descriptor.java.DataHelper;

public class CharacterStreamImpl
implements CharacterStream {
    private final long length;
    private Reader reader;
    private String string;

    public CharacterStreamImpl(String string) {
        this.string = string;
        this.length = string.length();
    }

    public CharacterStreamImpl(Reader reader, long l) {
        this.reader = reader;
        this.length = l;
    }

    public Reader asReader() {
        if (this.reader == null) {
            this.reader = new StringReader(this.string);
        }
        return this.reader;
    }

    public String asString() {
        if (this.string == null) {
            this.string = DataHelper.extractString(this.reader);
        }
        return this.string;
    }

    public long getLength() {
        return this.length;
    }

    public void release() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

