/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.hibernate.engine.jdbc.batch.internal.AbstractBatchImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class NonBatchingBatch
extends AbstractBatchImpl {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, NonBatchingBatch.class.getName());
    private JdbcCoordinator jdbcCoordinator;

    protected NonBatchingBatch(BatchKey batchKey, JdbcCoordinator jdbcCoordinator) {
        super(batchKey, jdbcCoordinator);
        this.jdbcCoordinator = jdbcCoordinator;
    }

    public void addToBatch() {
        this.notifyObserversImplicitExecution();
        for (Map.Entry<String, PreparedStatement> entry : this.getStatements().entrySet()) {
            try {
                PreparedStatement preparedStatement = entry.getValue();
                int n = this.jdbcCoordinator.getResultSetReturn().executeUpdate(preparedStatement);
                this.getKey().getExpectation().verifyOutcome(n, preparedStatement, 0);
                this.jdbcCoordinator.release(preparedStatement);
            }
            catch (SQLException sQLException) {
                LOG.debug("SQLException escaped proxy", sQLException);
                throw this.sqlExceptionHelper().convert(sQLException, "could not execute batch statement", entry.getKey());
            }
        }
        this.getStatements().clear();
    }

    protected void doExecuteBatch() {
    }
}

