/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderImpl;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchBuilderInitiator
implements BasicServiceInitiator<BatchBuilder> {
    public static final BatchBuilderInitiator INSTANCE = new BatchBuilderInitiator();
    public static final String BUILDER = "hibernate.jdbc.batch.builder";

    @Override
    public Class<BatchBuilder> getServiceInitiated() {
        return BatchBuilder.class;
    }

    @Override
    public BatchBuilder initiateService(Map map, ServiceRegistryImplementor serviceRegistryImplementor) {
        Object v = map.get(BUILDER);
        if (v == null) {
            return new BatchBuilderImpl(ConfigurationHelper.getInt("hibernate.jdbc.batch_size", map, 1));
        }
        if (BatchBuilder.class.isInstance(v)) {
            return (BatchBuilder)v;
        }
        String string = v.toString();
        try {
            return (BatchBuilder)serviceRegistryImplementor.getService(ClassLoaderService.class).classForName(string).newInstance();
        }
        catch (Exception exception) {
            throw new ServiceException("Could not build explicit BatchBuilder [" + string + "]", exception);
        }
    }
}

