/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.internal.BatchingBatch;
import org.hibernate.engine.jdbc.batch.internal.NonBatchingBatch;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.Configurable;
import org.jboss.logging.Logger;

public class BatchBuilderImpl
implements BatchBuilder,
Configurable {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, BatchBuilderImpl.class.getName());
    private int size;

    public BatchBuilderImpl() {
    }

    public void configure(Map map) {
        this.size = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", map, this.size);
    }

    public BatchBuilderImpl(int n) {
        this.size = n;
    }

    public void setJdbcBatchSize(int n) {
        this.size = n;
    }

    public Batch buildBatch(BatchKey batchKey, JdbcCoordinator jdbcCoordinator) {
        LOG.tracef("Building batch [size=%s]", (Object)this.size);
        return this.size > 1 ? new BatchingBatch(batchKey, jdbcCoordinator, this.size) : new NonBatchingBatch(batchKey, jdbcCoordinator);
    }

    public String getManagementDomain() {
        return null;
    }

    public String getManagementServiceType() {
        return null;
    }

    public Object getManagementBean() {
        return this;
    }
}

