/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.batch.spi.BatchObserver;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBatchImpl
implements Batch {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractBatchImpl.class.getName());
    private final BatchKey key;
    private final JdbcCoordinator jdbcCoordinator;
    private LinkedHashMap<String, PreparedStatement> statements = new LinkedHashMap();
    private LinkedHashSet<BatchObserver> observers = new LinkedHashSet();

    protected AbstractBatchImpl(BatchKey batchKey, JdbcCoordinator jdbcCoordinator) {
        if (batchKey == null) {
            throw new IllegalArgumentException("batch key cannot be null");
        }
        if (jdbcCoordinator == null) {
            throw new IllegalArgumentException("JDBC coordinator cannot be null");
        }
        this.key = batchKey;
        this.jdbcCoordinator = jdbcCoordinator;
    }

    protected abstract void doExecuteBatch();

    protected SqlExceptionHelper sqlExceptionHelper() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlExceptionHelper();
    }

    protected SqlStatementLogger sqlStatementLogger() {
        return this.jdbcCoordinator.getTransactionCoordinator().getTransactionContext().getTransactionEnvironment().getJdbcServices().getSqlStatementLogger();
    }

    protected LinkedHashMap<String, PreparedStatement> getStatements() {
        return this.statements;
    }

    @Override
    public final BatchKey getKey() {
        return this.key;
    }

    @Override
    public void addObserver(BatchObserver batchObserver) {
        this.observers.add(batchObserver);
    }

    @Override
    public PreparedStatement getBatchStatement(String string, boolean bl) {
        if (string == null) {
            throw new IllegalArgumentException("sql must be non-null.");
        }
        PreparedStatement preparedStatement = this.statements.get(string);
        if (preparedStatement == null) {
            preparedStatement = this.buildBatchStatement(string, bl);
            this.statements.put(string, preparedStatement);
        } else {
            LOG.debug("Reusing batch statement");
            this.sqlStatementLogger().logStatement(string);
        }
        return preparedStatement;
    }

    private PreparedStatement buildBatchStatement(String string, boolean bl) {
        return this.jdbcCoordinator.getStatementPreparer().prepareStatement(string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute() {
        this.notifyObserversExplicitExecution();
        if (this.statements.isEmpty()) {
            return;
        }
        try {
            try {
                this.doExecuteBatch();
            }
            finally {
                this.releaseStatements();
            }
        }
        finally {
            this.statements.clear();
        }
    }

    private void releaseStatements() {
        for (PreparedStatement preparedStatement : this.getStatements().values()) {
            try {
                preparedStatement.clearBatch();
                this.jdbcCoordinator.release(preparedStatement);
            }
            catch (SQLException sQLException) {
                LOG.unableToReleaseBatchStatement();
                LOG.sqlExceptionEscapedProxy(sQLException);
            }
        }
        this.getStatements().clear();
    }

    protected final void notifyObserversExplicitExecution() {
        for (BatchObserver batchObserver : this.observers) {
            batchObserver.batchExplicitlyExecuted();
        }
    }

    protected final void notifyObserversImplicitExecution() {
        for (BatchObserver batchObserver : this.observers) {
            batchObserver.batchImplicitlyExecuted();
        }
    }

    @Override
    public void release() {
        if (this.getStatements() != null && !this.getStatements().isEmpty()) {
            LOG.batchContainedStatementsOnRelease();
        }
        this.releaseStatements();
        this.observers.clear();
    }
}

