/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.ColumnNameCache;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.jboss.logging.Logger;

public class ResultSetWrapperProxy
implements InvocationHandler {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, ResultSetWrapperProxy.class.getName());
    private static final Class[] PROXY_INTERFACES = new Class[]{ResultSet.class};
    private static final SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper();
    private final ResultSet rs;
    private final ColumnNameCache columnNameCache;

    private ResultSetWrapperProxy(ResultSet resultSet, ColumnNameCache columnNameCache) {
        this.rs = resultSet;
        this.columnNameCache = columnNameCache;
    }

    public static ResultSet generateProxy(ResultSet resultSet, ColumnNameCache columnNameCache) {
        return (ResultSet)Proxy.newProxyInstance(ResultSetWrapperProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new ResultSetWrapperProxy(resultSet, columnNameCache));
    }

    public static ClassLoader getProxyClassLoader() {
        ClassLoader classLoader = ClassLoaderHelper.getContextClassLoader();
        if (classLoader == null) {
            classLoader = ResultSet.class.getClassLoader();
        }
        return classLoader;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        if ("findColumn".equals(method.getName())) {
            return this.findColumn((String)objectArray[0]);
        }
        if (this.isFirstArgColumnLabel(method, objectArray)) {
            try {
                int n = this.findColumn((String)objectArray[0]);
                return this.invokeMethod(this.locateCorrespondingColumnIndexMethod(method), this.buildColumnIndexMethodArgs(objectArray, n));
            }
            catch (SQLException sQLException) {
                StringBuilder stringBuilder = new StringBuilder().append("Exception getting column index for column: [").append(objectArray[0]).append("].\nReverting to using: [").append(objectArray[0]).append("] as first argument for method: [").append(method).append("]");
                sqlExceptionHelper.logExceptions(sQLException, stringBuilder.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LOG.unableToSwitchToMethodUsingColumnIndex(method);
            }
        }
        return this.invokeMethod(method, objectArray);
    }

    private int findColumn(String string) throws SQLException {
        return this.columnNameCache.getIndexForColumnName(string, this.rs);
    }

    private boolean isFirstArgColumnLabel(Method method, Object[] objectArray) {
        if (!method.getName().startsWith("get") && !method.getName().startsWith("update")) {
            return false;
        }
        if (method.getParameterTypes().length <= 0 || objectArray.length != method.getParameterTypes().length) {
            return false;
        }
        return String.class.isInstance(objectArray[0]) && method.getParameterTypes()[0].equals(String.class);
    }

    private Method locateCorrespondingColumnIndexMethod(Method method) throws NoSuchMethodException {
        Class[] classArray = new Class[method.getParameterTypes().length];
        classArray[0] = Integer.TYPE;
        System.arraycopy(method.getParameterTypes(), 1, classArray, 1, method.getParameterTypes().length - 1);
        return method.getDeclaringClass().getMethod(method.getName(), classArray);
    }

    private Object[] buildColumnIndexMethodArgs(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[objectArray.length];
        objectArray2[0] = n;
        System.arraycopy(objectArray, 1, objectArray2, 1, objectArray.length - 1);
        return objectArray2;
    }

    private Object invokeMethod(Method method, Object[] objectArray) throws Throwable {
        try {
            return method.invoke((Object)this.rs, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }
}

