/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.AbstractLobCreator;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;

public class ContextualLobCreator
extends AbstractLobCreator
implements LobCreator {
    private LobCreationContext lobCreationContext;
    public static final LobCreationContext.Callback<Blob> CREATE_BLOB_CALLBACK = new LobCreationContext.Callback<Blob>(){

        @Override
        public Blob executeOnConnection(Connection connection) throws SQLException {
            return connection.createBlob();
        }
    };
    public static final LobCreationContext.Callback<Clob> CREATE_CLOB_CALLBACK = new LobCreationContext.Callback<Clob>(){

        @Override
        public Clob executeOnConnection(Connection connection) throws SQLException {
            return connection.createClob();
        }
    };
    public static final LobCreationContext.Callback<NClob> CREATE_NCLOB_CALLBACK = new LobCreationContext.Callback<NClob>(){

        @Override
        public NClob executeOnConnection(Connection connection) throws SQLException {
            return connection.createNClob();
        }
    };

    public ContextualLobCreator(LobCreationContext lobCreationContext) {
        this.lobCreationContext = lobCreationContext;
    }

    public Blob createBlob() {
        return this.lobCreationContext.execute(CREATE_BLOB_CALLBACK);
    }

    public Blob createBlob(byte[] byArray) {
        try {
            Blob blob = this.createBlob();
            blob.setBytes(1L, byArray);
            return blob;
        }
        catch (SQLException sQLException) {
            throw new JDBCException("Unable to set BLOB bytes after creation", sQLException);
        }
    }

    public Blob createBlob(InputStream inputStream, long l) {
        return NonContextualLobCreator.INSTANCE.createBlob(inputStream, l);
    }

    public Clob createClob() {
        return this.lobCreationContext.execute(CREATE_CLOB_CALLBACK);
    }

    public Clob createClob(String string) {
        try {
            Clob clob = this.createClob();
            clob.setString(1L, string);
            return clob;
        }
        catch (SQLException sQLException) {
            throw new JDBCException("Unable to set CLOB string after creation", sQLException);
        }
    }

    public Clob createClob(Reader reader, long l) {
        return NonContextualLobCreator.INSTANCE.createClob(reader, l);
    }

    public NClob createNClob() {
        return this.lobCreationContext.execute(CREATE_NCLOB_CALLBACK);
    }

    public NClob createNClob(String string) {
        try {
            NClob nClob = this.createNClob();
            nClob.setString(1L, string);
            return nClob;
        }
        catch (SQLException sQLException) {
            throw new JDBCException("Unable to set NCLOB string after creation", sQLException);
        }
    }

    public NClob createNClob(Reader reader, long l) {
        return NonContextualLobCreator.INSTANCE.createNClob(reader, l);
    }
}

