/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;

public class ColumnNameCache {
    public static final float LOAD_FACTOR = 0.75f;
    private final ConcurrentHashMap<String, Integer> columnNameToIndexCache;

    public ColumnNameCache(int n) {
        this.columnNameToIndexCache = new ConcurrentHashMap(n + (int)((float)n * 0.75f) + 1, 0.75f);
    }

    public int getIndexForColumnName(String string, ResultSet resultSet) throws SQLException {
        Integer n = this.columnNameToIndexCache.get(string);
        if (n != null) {
            return n;
        }
        int n2 = resultSet.findColumn(string);
        this.columnNameToIndexCache.put(string, n2);
        return n2;
    }
}

