/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Blob;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.BinaryStream;
import org.hibernate.engine.jdbc.BlobImplementer;
import org.hibernate.engine.jdbc.internal.BinaryStreamImpl;
import org.hibernate.internal.util.ClassLoaderHelper;
import org.hibernate.type.descriptor.java.DataHelper;

public class BlobProxy
implements InvocationHandler {
    private static final Class[] PROXY_INTERFACES = new Class[]{Blob.class, BlobImplementer.class};
    private BinaryStream binaryStream;
    private boolean needsReset = false;

    private BlobProxy(byte[] byArray) {
        this.binaryStream = new BinaryStreamImpl(byArray);
    }

    private BlobProxy(InputStream inputStream, long l) {
        this.binaryStream = new StreamBackedBinaryStream(inputStream, l);
    }

    private long getLength() {
        return this.binaryStream.getLength();
    }

    private InputStream getStream() throws SQLException {
        return this.getUnderlyingStream().getInputStream();
    }

    private BinaryStream getUnderlyingStream() throws SQLException {
        this.resetIfNeeded();
        return this.binaryStream;
    }

    private void resetIfNeeded() throws SQLException {
        try {
            if (this.needsReset) {
                this.binaryStream.getInputStream().reset();
            }
        }
        catch (IOException iOException) {
            throw new SQLException("could not reset reader");
        }
        this.needsReset = true;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        int n = method.getParameterTypes().length;
        if ("length".equals(string) && n == 0) {
            return this.getLength();
        }
        if ("getUnderlyingStream".equals(string)) {
            return this.getUnderlyingStream();
        }
        if ("getBinaryStream".equals(string)) {
            if (n == 0) {
                return this.getStream();
            }
            if (n == 2) {
                long l = (Long)objectArray[0];
                if (l < 1L) {
                    throw new SQLException("Start position 1-based; must be 1 or more.");
                }
                if (l > this.getLength()) {
                    throw new SQLException("Start position [" + l + "] cannot exceed overall CLOB length [" + this.getLength() + "]");
                }
                int n2 = (Integer)objectArray[1];
                if (n2 < 0) {
                    throw new SQLException("Length must be great-than-or-equal to zero.");
                }
                return DataHelper.subStream(this.getStream(), l - 1L, n2);
            }
        }
        if ("getBytes".equals(string) && n == 2) {
            long l = (Long)objectArray[0];
            if (l < 1L) {
                throw new SQLException("Start position 1-based; must be 1 or more.");
            }
            int n3 = (Integer)objectArray[1];
            if (n3 < 0) {
                throw new SQLException("Length must be great-than-or-equal to zero.");
            }
            return DataHelper.extractBytes(this.getStream(), l - 1L, n3);
        }
        if ("free".equals(string) && n == 0) {
            this.binaryStream.release();
            return null;
        }
        if ("toString".equals(string) && n == 0) {
            return this.toString();
        }
        if ("equals".equals(string) && n == 1) {
            return object == objectArray[0];
        }
        if ("hashCode".equals(string) && n == 0) {
            return this.hashCode();
        }
        throw new UnsupportedOperationException("Blob may not be manipulated from creating session");
    }

    public static Blob generateProxy(byte[] byArray) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(byArray));
    }

    public static Blob generateProxy(InputStream inputStream, long l) {
        return (Blob)Proxy.newProxyInstance(BlobProxy.getProxyClassLoader(), PROXY_INTERFACES, (InvocationHandler)new BlobProxy(inputStream, l));
    }

    private static ClassLoader getProxyClassLoader() {
        ClassLoader classLoader = ClassLoaderHelper.getContextClassLoader();
        if (classLoader == null) {
            classLoader = BlobImplementer.class.getClassLoader();
        }
        return classLoader;
    }

    private static class StreamBackedBinaryStream
    implements BinaryStream {
        private final InputStream stream;
        private final long length;
        private byte[] bytes;

        private StreamBackedBinaryStream(InputStream inputStream, long l) {
            this.stream = inputStream;
            this.length = l;
        }

        public InputStream getInputStream() {
            return this.stream;
        }

        public byte[] getBytes() {
            if (this.bytes == null) {
                this.bytes = DataHelper.extractBytes(this.stream);
            }
            return this.bytes;
        }

        public long getLength() {
            return (int)this.length;
        }

        public void release() {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

