/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.VersionType;
import org.jboss.logging.Logger;

public final class Versioning {
    public static final int OPTIMISTIC_LOCK_NONE = -1;
    public static final int OPTIMISTIC_LOCK_VERSION = 0;
    public static final int OPTIMISTIC_LOCK_ALL = 2;
    public static final int OPTIMISTIC_LOCK_DIRTY = 1;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Versioning.class.getName());

    private Versioning() {
    }

    private static Object seed(VersionType versionType, SessionImplementor sessionImplementor) {
        Object t = versionType.seed(sessionImplementor);
        LOG.tracev("Seeding: {0}", t);
        return t;
    }

    public static boolean seedVersion(Object[] objectArray, int n, VersionType versionType, SessionImplementor sessionImplementor) {
        Object object = objectArray[n];
        if (object == null || object instanceof Number && ((Number)object).longValue() < 0L) {
            objectArray[n] = Versioning.seed(versionType, sessionImplementor);
            return true;
        }
        LOG.tracev("Using initial version: {0}", object);
        return false;
    }

    public static Object increment(Object object, VersionType versionType, SessionImplementor sessionImplementor) {
        Object object2 = versionType.next(object, sessionImplementor);
        if (LOG.isTraceEnabled()) {
            LOG.tracev("Incrementing: {0} to {1}", (Object)versionType.toLoggableString(object, sessionImplementor.getFactory()), (Object)versionType.toLoggableString(object2, sessionImplementor.getFactory()));
        }
        return object2;
    }

    public static void setVersion(Object[] objectArray, Object object, EntityPersister entityPersister) {
        if (!entityPersister.isVersioned()) {
            return;
        }
        objectArray[entityPersister.getVersionProperty()] = object;
    }

    public static Object getVersion(Object[] objectArray, EntityPersister entityPersister) {
        if (!entityPersister.isVersioned()) {
            return null;
        }
        return objectArray[entityPersister.getVersionProperty()];
    }

    public static boolean isVersionIncrementRequired(int[] nArray, boolean bl, boolean[] blArray) {
        if (bl) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (!blArray[nArray[i]]) continue;
            return true;
        }
        return false;
    }
}

