/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.hibernate.InstantiationException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.IdentifierValue;
import org.hibernate.engine.spi.VersionValue;
import org.hibernate.property.Getter;
import org.hibernate.type.IdentifierType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.type.VersionType;

public class UnsavedValueFactory {
    private static Object instantiate(Constructor constructor) {
        try {
            return constructor.newInstance(null);
        }
        catch (Exception exception) {
            throw new InstantiationException("could not instantiate test object", constructor.getDeclaringClass(), exception);
        }
    }

    public static IdentifierValue getUnsavedIdentifierValue(String string, Getter getter, Type type, Constructor constructor) {
        if (string == null) {
            if (getter != null && constructor != null) {
                Serializable serializable = (Serializable)getter.get(UnsavedValueFactory.instantiate(constructor));
                return new IdentifierValue(serializable);
            }
            if (getter != null && type instanceof PrimitiveType) {
                Serializable serializable = ((PrimitiveType)((Object)type)).getDefaultValue();
                return new IdentifierValue(serializable);
            }
            return IdentifierValue.NULL;
        }
        if ("null".equals(string)) {
            return IdentifierValue.NULL;
        }
        if ("undefined".equals(string)) {
            return IdentifierValue.UNDEFINED;
        }
        if ("none".equals(string)) {
            return IdentifierValue.NONE;
        }
        if ("any".equals(string)) {
            return IdentifierValue.ANY;
        }
        try {
            return new IdentifierValue((Serializable)((IdentifierType)type).stringToObject(string));
        }
        catch (ClassCastException classCastException) {
            throw new MappingException("Bad identifier type: " + type.getName());
        }
        catch (Exception exception) {
            throw new MappingException("Could not parse identifier unsaved-value: " + string);
        }
    }

    public static VersionValue getUnsavedVersionValue(String string, Getter getter, VersionType versionType, Constructor constructor) {
        if (string == null) {
            if (constructor != null) {
                Object object = getter.get(UnsavedValueFactory.instantiate(constructor));
                return versionType.isEqual(versionType.seed(null), object) ? VersionValue.UNDEFINED : new VersionValue(object);
            }
            return VersionValue.UNDEFINED;
        }
        if ("undefined".equals(string)) {
            return VersionValue.UNDEFINED;
        }
        if ("null".equals(string)) {
            return VersionValue.NULL;
        }
        if ("negative".equals(string)) {
            return VersionValue.NEGATIVE;
        }
        throw new MappingException("Could not parse version unsaved-value: " + string);
    }
}

