/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Iterator;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostLoadEvent;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PreLoadEvent;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.property.BackrefPropertyAccessor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.Type;
import org.hibernate.type.TypeHelper;
import org.jboss.logging.Logger;

public final class TwoPhaseLoad {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, TwoPhaseLoad.class.getName());

    private TwoPhaseLoad() {
    }

    public static void postHydrate(EntityPersister entityPersister, Serializable serializable, Object[] objectArray, Object object, Object object2, LockMode lockMode, boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        Object object3 = Versioning.getVersion(objectArray, entityPersister);
        sessionImplementor.getPersistenceContext().addEntry(object2, Status.LOADING, objectArray, object, serializable, object3, lockMode, true, entityPersister, false, bl);
        if (object3 != null && LOG.isTraceEnabled()) {
            String string = entityPersister.isVersioned() ? entityPersister.getVersionType().toLoggableString(object3, sessionImplementor.getFactory()) : "null";
            LOG.tracev("Version: {0}", (Object)string);
        }
    }

    public static void initializeEntity(Object object, boolean bl, SessionImplementor sessionImplementor, PreLoadEvent preLoadEvent, PostLoadEvent postLoadEvent) throws HibernateException {
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        EntityEntry entityEntry = persistenceContext.getEntry(object);
        if (entityEntry == null) {
            throw new AssertionFailure("possible non-threadsafe access to the session");
        }
        EntityPersister entityPersister = entityEntry.getPersister();
        Serializable serializable = entityEntry.getId();
        TwoPhaseLoad.doInitializeEntity(object, entityEntry, bl, sessionImplementor, preLoadEvent, postLoadEvent);
    }

    private static void doInitializeEntity(Object object, EntityEntry entityEntry, boolean bl, SessionImplementor sessionImplementor, PreLoadEvent preLoadEvent, PostLoadEvent postLoadEvent) throws HibernateException {
        Iterator<PreLoadEventListener> iterator;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        EntityPersister entityPersister = entityEntry.getPersister();
        Serializable serializable = entityEntry.getId();
        Object[] objectArray = entityEntry.getLoadedState();
        boolean bl2 = LOG.isDebugEnabled();
        if (bl2) {
            LOG.debugf("Resolving associations for %s", (Object)MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
        }
        Type[] typeArray = entityPersister.getPropertyTypes();
        for (int i = 0; i < objectArray.length; ++i) {
            iterator = objectArray[i];
            if (iterator == LazyPropertyInitializer.UNFETCHED_PROPERTY || iterator == BackrefPropertyAccessor.UNKNOWN) continue;
            objectArray[i] = typeArray[i].resolve(iterator, sessionImplementor, object);
        }
        if (sessionImplementor.isEventSource()) {
            preLoadEvent.setEntity(object).setState(objectArray).setId(serializable).setPersister(entityPersister);
            EventListenerGroup<PreLoadEventListener> eventListenerGroup = sessionImplementor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.PRE_LOAD);
            for (PreLoadEventListener object22 : eventListenerGroup.listeners()) {
                object22.onPreLoad(preLoadEvent);
            }
        }
        entityPersister.setPropertyValues(object, objectArray);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        if (entityPersister.hasCache() && sessionImplementor.getCacheMode().isPutEnabled()) {
            if (bl2) {
                LOG.debugf("Adding entity to second-level cache: %s", (Object)MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
            }
            iterator = Versioning.getVersion(objectArray, entityPersister);
            CacheEntry cacheEntry = entityPersister.buildCacheEntry(object, objectArray, iterator, sessionImplementor);
            CacheKey cacheKey = sessionImplementor.generateCacheKey(serializable, entityPersister.getIdentifierType(), entityPersister.getRootEntityName());
            if (sessionImplementor.getPersistenceContext().wasInsertedDuringTransaction(entityPersister, serializable)) {
                entityPersister.getCacheAccessStrategy().update(cacheKey, entityPersister.getCacheEntryStructure().structure(cacheEntry), iterator, iterator);
            } else {
                boolean bl3 = entityPersister.getCacheAccessStrategy().putFromLoad(cacheKey, entityPersister.getCacheEntryStructure().structure(cacheEntry), sessionImplementor.getTimestamp(), iterator, TwoPhaseLoad.useMinimalPuts(sessionImplementor, entityEntry));
                if (bl3 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                    sessionFactoryImplementor.getStatisticsImplementor().secondLevelCachePut(entityPersister.getCacheAccessStrategy().getRegion().getName());
                }
            }
        }
        if (entityPersister.hasNaturalIdentifier()) {
            persistenceContext.getNaturalIdHelper().cacheNaturalIdCrossReferenceFromLoad(entityPersister, serializable, persistenceContext.getNaturalIdHelper().extractNaturalIdValues(objectArray, entityPersister));
        }
        boolean bl4 = bl;
        if (!entityPersister.isMutable()) {
            bl4 = true;
        } else {
            Object object2 = persistenceContext.getProxy(entityEntry.getEntityKey());
            if (object2 != null) {
                bl4 = ((HibernateProxy)object2).getHibernateLazyInitializer().isReadOnly();
            }
        }
        if (bl4) {
            persistenceContext.setEntryStatus(entityEntry, Status.READ_ONLY);
        } else {
            TypeHelper.deepCopy(objectArray, entityPersister.getPropertyTypes(), entityPersister.getPropertyUpdateability(), objectArray, sessionImplementor);
            persistenceContext.setEntryStatus(entityEntry, Status.MANAGED);
        }
        entityPersister.afterInitialize(object, entityEntry.isLoadedWithLazyPropertiesUnfetched(), sessionImplementor);
        if (bl2) {
            LOG.debugf("Done materializing entity %s", (Object)MessageHelper.infoString(entityPersister, serializable, sessionImplementor.getFactory()));
        }
        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().loadEntity(entityPersister.getEntityName());
        }
    }

    public static void postLoad(Object object, SessionImplementor sessionImplementor, PostLoadEvent postLoadEvent) {
        if (sessionImplementor.isEventSource()) {
            PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
            EntityEntry entityEntry = persistenceContext.getEntry(object);
            Serializable serializable = entityEntry.getId();
            postLoadEvent.setEntity(object).setId(entityEntry.getId()).setPersister(entityEntry.getPersister());
            EventListenerGroup<PostLoadEventListener> eventListenerGroup = sessionImplementor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class).getEventListenerGroup(EventType.POST_LOAD);
            for (PostLoadEventListener postLoadEventListener : eventListenerGroup.listeners()) {
                postLoadEventListener.onPostLoad(postLoadEvent);
            }
        }
    }

    private static boolean useMinimalPuts(SessionImplementor sessionImplementor, EntityEntry entityEntry) {
        return sessionImplementor.getFactory().getSettings().isMinimalPutsEnabled() && sessionImplementor.getCacheMode() != CacheMode.REFRESH || entityEntry.getPersister().hasLazyProperties() && entityEntry.isLoadedWithLazyPropertiesUnfetched() && entityEntry.getPersister().isLazyPropertiesCacheable();
    }

    public static void addUninitializedEntity(EntityKey entityKey, Object object, EntityPersister entityPersister, LockMode lockMode, boolean bl, SessionImplementor sessionImplementor) {
        sessionImplementor.getPersistenceContext().addEntity(object, Status.LOADING, null, entityKey, null, lockMode, true, entityPersister, false, bl);
    }

    public static void addUninitializedCachedEntity(EntityKey entityKey, Object object, EntityPersister entityPersister, LockMode lockMode, boolean bl, Object object2, SessionImplementor sessionImplementor) {
        sessionImplementor.getPersistenceContext().addEntity(object, Status.LOADING, null, entityKey, object2, lockMode, true, entityPersister, false, bl);
    }
}

