/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueObjectException;
import org.hibernate.PersistentObjectException;
import org.hibernate.TransientObjectException;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.EntityEntryContext;
import org.hibernate.engine.internal.NaturalIdXrefDelegate;
import org.hibernate.engine.loading.internal.LoadContexts;
import org.hibernate.engine.spi.AssociationKey;
import org.hibernate.engine.spi.BatchFetchQueue;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.ConcurrentReferenceHashMap;
import org.hibernate.internal.util.collections.IdentityMap;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.tuple.ElementWrapper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulPersistenceContext
implements PersistenceContext {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, StatefulPersistenceContext.class.getName());
    private static final boolean tracing = LOG.isTraceEnabled();
    public static final Object NO_ROW = new MarkerObject("NO_ROW");
    public static final int INIT_COLL_SIZE = 8;
    private SessionImplementor session;
    private Map<EntityKey, Object> entitiesByKey;
    private Map<EntityUniqueKey, Object> entitiesByUniqueKey;
    private EntityEntryContext entityEntryContext;
    private Map<EntityKey, Object> proxiesByKey;
    private Map<EntityKey, Object> entitySnapshotsByKey;
    private Map<Object, PersistentCollection> arrayHolders;
    private IdentityMap<PersistentCollection, CollectionEntry> collectionEntries;
    private Map<CollectionKey, PersistentCollection> collectionsByKey;
    private HashSet<EntityKey> nullifiableEntityKeys;
    private HashSet<AssociationKey> nullAssociations;
    private List<PersistentCollection> nonlazyCollections;
    private Map<CollectionKey, PersistentCollection> unownedCollections;
    private Map<Object, Object> parentsByChild;
    private int cascading = 0;
    private int loadCounter = 0;
    private boolean flushing = false;
    private boolean defaultReadOnly = false;
    private boolean hasNonReadOnlyEntities = false;
    private LoadContexts loadContexts;
    private BatchFetchQueue batchFetchQueue;
    private HashMap<String, List<Serializable>> insertedKeysMap;
    private final NaturalIdXrefDelegate naturalIdXrefDelegate = new NaturalIdXrefDelegate(this);
    private final PersistenceContext.NaturalIdHelper naturalIdHelper = new PersistenceContext.NaturalIdHelper(){

        @Override
        public void cacheNaturalIdCrossReferenceFromLoad(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
            if (!entityPersister.hasNaturalIdentifier()) {
                return;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            boolean bl = StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(entityPersister, serializable, objectArray);
            if (bl && entityPersister.hasNaturalIdCache()) {
                this.managedSharedCacheEntries(entityPersister, serializable, objectArray, null, CachedNaturalIdValueSource.LOAD);
            }
        }

        @Override
        public void manageLocalNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray, Object[] objectArray2, CachedNaturalIdValueSource cachedNaturalIdValueSource) {
            if (!entityPersister.hasNaturalIdentifier()) {
                return;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            Object[] objectArray3 = this.extractNaturalIdValues(objectArray, entityPersister);
            StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(entityPersister, serializable, objectArray3);
        }

        @Override
        public void manageSharedNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray, Object[] objectArray2, CachedNaturalIdValueSource cachedNaturalIdValueSource) {
            if (!entityPersister.hasNaturalIdentifier()) {
                return;
            }
            if (!entityPersister.hasNaturalIdCache()) {
                return;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            Object[] objectArray3 = this.extractNaturalIdValues(objectArray, entityPersister);
            Object[] objectArray4 = objectArray2 == null ? null : this.extractNaturalIdValues(objectArray2, entityPersister);
            this.managedSharedCacheEntries(entityPersister, serializable, objectArray3, objectArray4, cachedNaturalIdValueSource);
        }

        private void managedSharedCacheEntries(EntityPersister entityPersister, final Serializable serializable, Object[] objectArray, Object[] objectArray2, CachedNaturalIdValueSource cachedNaturalIdValueSource) {
            final NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy = entityPersister.getNaturalIdCacheAccessStrategy();
            final NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(objectArray, entityPersister, StatefulPersistenceContext.this.session);
            final SessionFactoryImplementor sessionFactoryImplementor = StatefulPersistenceContext.this.session.getFactory();
            switch (cachedNaturalIdValueSource) {
                case LOAD: {
                    if (naturalIdRegionAccessStrategy.get(naturalIdCacheKey, StatefulPersistenceContext.this.session.getTimestamp()) != null) {
                        return;
                    }
                    boolean bl = naturalIdRegionAccessStrategy.putFromLoad(naturalIdCacheKey, serializable, StatefulPersistenceContext.this.session.getTimestamp(), null);
                    if (!bl || !sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) break;
                    sessionFactoryImplementor.getStatisticsImplementor().naturalIdCachePut(naturalIdRegionAccessStrategy.getRegion().getName());
                    break;
                }
                case INSERT: {
                    boolean bl = naturalIdRegionAccessStrategy.insert(naturalIdCacheKey, serializable);
                    if (bl && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                        sessionFactoryImplementor.getStatisticsImplementor().naturalIdCachePut(naturalIdRegionAccessStrategy.getRegion().getName());
                    }
                    ((EventSource)StatefulPersistenceContext.this.session).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
                            if (bl) {
                                boolean bl2 = naturalIdRegionAccessStrategy.afterInsert(naturalIdCacheKey, serializable);
                                if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                                    sessionFactoryImplementor.getStatisticsImplementor().naturalIdCachePut(naturalIdRegionAccessStrategy.getRegion().getName());
                                }
                            } else {
                                naturalIdRegionAccessStrategy.remove(naturalIdCacheKey);
                            }
                        }
                    });
                    break;
                }
                case UPDATE: {
                    final NaturalIdCacheKey naturalIdCacheKey2 = new NaturalIdCacheKey(objectArray2, entityPersister, StatefulPersistenceContext.this.session);
                    if (naturalIdCacheKey.equals(naturalIdCacheKey2)) {
                        return;
                    }
                    final SoftLock softLock = naturalIdRegionAccessStrategy.lockItem(naturalIdCacheKey2, null);
                    naturalIdRegionAccessStrategy.remove(naturalIdCacheKey2);
                    final SoftLock softLock2 = naturalIdRegionAccessStrategy.lockItem(naturalIdCacheKey, null);
                    boolean bl = naturalIdRegionAccessStrategy.update(naturalIdCacheKey, serializable);
                    if (bl && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                        sessionFactoryImplementor.getStatisticsImplementor().naturalIdCachePut(naturalIdRegionAccessStrategy.getRegion().getName());
                    }
                    ((EventSource)StatefulPersistenceContext.this.session).getActionQueue().registerProcess(new AfterTransactionCompletionProcess(){

                        public void doAfterTransactionCompletion(boolean bl, SessionImplementor sessionImplementor) {
                            naturalIdRegionAccessStrategy.unlockItem(naturalIdCacheKey2, softLock);
                            if (bl) {
                                boolean bl2 = naturalIdRegionAccessStrategy.afterUpdate(naturalIdCacheKey, serializable, softLock2);
                                if (bl2 && sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                                    sessionFactoryImplementor.getStatisticsImplementor().naturalIdCachePut(naturalIdRegionAccessStrategy.getRegion().getName());
                                }
                            } else {
                                naturalIdRegionAccessStrategy.unlockItem(naturalIdCacheKey, softLock2);
                            }
                        }
                    });
                    break;
                }
            }
        }

        @Override
        public Object[] removeLocalNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
            if (!entityPersister.hasNaturalIdentifier()) {
                return null;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            Object[] objectArray2 = StatefulPersistenceContext.this.getNaturalIdValues(objectArray, entityPersister);
            Object[] objectArray3 = StatefulPersistenceContext.this.naturalIdXrefDelegate.removeNaturalIdCrossReference(entityPersister, serializable, objectArray2);
            return objectArray3 != null ? objectArray3 : objectArray2;
        }

        @Override
        public void removeSharedNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
            if (!entityPersister.hasNaturalIdentifier()) {
                return;
            }
            if (!entityPersister.hasNaturalIdCache()) {
                return;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy = entityPersister.getNaturalIdCacheAccessStrategy();
            NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(objectArray, entityPersister, StatefulPersistenceContext.this.session);
            naturalIdRegionAccessStrategy.evict(naturalIdCacheKey);
        }

        @Override
        public Object[] findCachedNaturalId(EntityPersister entityPersister, Serializable serializable) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalId(StatefulPersistenceContext.this.locateProperPersister(entityPersister), serializable);
        }

        @Override
        public Serializable findCachedNaturalIdResolution(EntityPersister entityPersister, Object[] objectArray) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalIdResolution(StatefulPersistenceContext.this.locateProperPersister(entityPersister), objectArray);
        }

        @Override
        public Object[] extractNaturalIdValues(Object[] objectArray, EntityPersister entityPersister) {
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            if (objectArray.length == nArray.length) {
                return objectArray;
            }
            Object[] objectArray2 = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray2[i] = objectArray[nArray[i]];
            }
            return objectArray2;
        }

        @Override
        public Object[] extractNaturalIdValues(Object object, EntityPersister entityPersister) {
            if (object == null) {
                throw new AssertionFailure("Entity from which to extract natural id value(s) cannot be null");
            }
            if (entityPersister == null) {
                throw new AssertionFailure("Persister to use in extracting natural id value(s) cannot be null");
            }
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            Object[] objectArray = new Object[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = entityPersister.getPropertyValue(object, nArray[i]);
            }
            return objectArray;
        }

        @Override
        public Collection<Serializable> getCachedPkResolutions(EntityPersister entityPersister) {
            return StatefulPersistenceContext.this.naturalIdXrefDelegate.getCachedPkResolutions(entityPersister);
        }

        @Override
        public void handleSynchronization(EntityPersister entityPersister, Serializable serializable, Object object) {
            boolean bl;
            if (!entityPersister.hasNaturalIdentifier()) {
                return;
            }
            entityPersister = StatefulPersistenceContext.this.locateProperPersister(entityPersister);
            Object[] objectArray = this.extractNaturalIdValues(object, entityPersister);
            boolean bl2 = bl = !StatefulPersistenceContext.this.naturalIdXrefDelegate.sameAsCached(entityPersister, serializable, objectArray);
            if (bl) {
                Object[] objectArray2 = StatefulPersistenceContext.this.naturalIdXrefDelegate.findCachedNaturalId(entityPersister, serializable);
                StatefulPersistenceContext.this.naturalIdXrefDelegate.cacheNaturalIdCrossReference(entityPersister, serializable, objectArray);
                StatefulPersistenceContext.this.naturalIdXrefDelegate.stashInvalidNaturalIdReference(entityPersister, objectArray2);
                this.removeSharedNaturalIdCrossReference(entityPersister, serializable, objectArray2);
            }
        }

        @Override
        public void cleanupFromSynchronizations() {
            StatefulPersistenceContext.this.naturalIdXrefDelegate.unStashInvalidNaturalIdReferences();
        }

        @Override
        public void handleEviction(Object object, EntityPersister entityPersister, Serializable serializable) {
            StatefulPersistenceContext.this.naturalIdXrefDelegate.removeNaturalIdCrossReference(entityPersister, serializable, this.findCachedNaturalId(entityPersister, serializable));
        }
    };

    public StatefulPersistenceContext(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.entitiesByKey = new HashMap<EntityKey, Object>(8);
        this.entitiesByUniqueKey = new HashMap<EntityUniqueKey, Object>(8);
        this.proxiesByKey = new ConcurrentReferenceHashMap<EntityKey, Object>(8, 0.75f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, null);
        this.entitySnapshotsByKey = new HashMap<EntityKey, Object>(8);
        this.entityEntryContext = new EntityEntryContext();
        this.collectionEntries = IdentityMap.instantiateSequenced(8);
        this.parentsByChild = new IdentityHashMap<Object, Object>(8);
        this.collectionsByKey = new HashMap<CollectionKey, PersistentCollection>(8);
        this.arrayHolders = new IdentityHashMap<Object, PersistentCollection>(8);
        this.nullifiableEntityKeys = new HashSet();
        this.initTransientState();
    }

    private void initTransientState() {
        this.nullAssociations = new HashSet(8);
        this.nonlazyCollections = new ArrayList<PersistentCollection>(8);
    }

    @Override
    public boolean isStateless() {
        return false;
    }

    @Override
    public SessionImplementor getSession() {
        return this.session;
    }

    @Override
    public LoadContexts getLoadContexts() {
        if (this.loadContexts == null) {
            this.loadContexts = new LoadContexts(this);
        }
        return this.loadContexts;
    }

    @Override
    public void addUnownedCollection(CollectionKey collectionKey, PersistentCollection persistentCollection) {
        if (this.unownedCollections == null) {
            this.unownedCollections = new HashMap<CollectionKey, PersistentCollection>(8);
        }
        this.unownedCollections.put(collectionKey, persistentCollection);
    }

    @Override
    public PersistentCollection useUnownedCollection(CollectionKey collectionKey) {
        return this.unownedCollections == null ? null : this.unownedCollections.remove(collectionKey);
    }

    @Override
    public BatchFetchQueue getBatchFetchQueue() {
        if (this.batchFetchQueue == null) {
            this.batchFetchQueue = new BatchFetchQueue(this);
        }
        return this.batchFetchQueue;
    }

    @Override
    public void clear() {
        for (Object object : this.proxiesByKey.values()) {
            if (object == null) continue;
            ((HibernateProxy)object).getHibernateLazyInitializer().unsetSession();
        }
        for (Map.Entry<PersistentCollection, CollectionEntry> entry : IdentityMap.concurrentEntries(this.collectionEntries)) {
            entry.getKey().unsetSession(this.getSession());
        }
        this.arrayHolders.clear();
        this.entitiesByKey.clear();
        this.entitiesByUniqueKey.clear();
        this.entityEntryContext.clear();
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.clear();
        this.collectionsByKey.clear();
        this.collectionEntries.clear();
        if (this.unownedCollections != null) {
            this.unownedCollections.clear();
        }
        this.proxiesByKey.clear();
        this.nullifiableEntityKeys.clear();
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.clear();
        }
        this.hasNonReadOnlyEntities = false;
        if (this.loadContexts != null) {
            this.loadContexts.cleanup();
        }
        this.naturalIdXrefDelegate.clear();
    }

    @Override
    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    @Override
    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl;
    }

    @Override
    public boolean hasNonReadOnlyEntities() {
        return this.hasNonReadOnlyEntities;
    }

    @Override
    public void setEntryStatus(EntityEntry entityEntry, Status status) {
        entityEntry.setStatus(status);
        this.setHasNonReadOnlyEnties(status);
    }

    private void setHasNonReadOnlyEnties(Status status) {
        if (status == Status.DELETED || status == Status.MANAGED || status == Status.SAVING) {
            this.hasNonReadOnlyEntities = true;
        }
    }

    @Override
    public void afterTransactionCompletion() {
        this.cleanUpInsertedKeysAfterTransaction();
        this.entityEntryContext.downgradeLocks();
    }

    @Override
    public Object[] getDatabaseSnapshot(Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        EntityKey entityKey = this.session.generateEntityKey(serializable, entityPersister);
        Object object = this.entitySnapshotsByKey.get(entityKey);
        if (object != null) {
            return object == NO_ROW ? null : (Object[])object;
        }
        Object[] objectArray = entityPersister.getDatabaseSnapshot(serializable, this.session);
        this.entitySnapshotsByKey.put(entityKey, objectArray == null ? NO_ROW : objectArray);
        return objectArray;
    }

    @Override
    public Object[] getNaturalIdSnapshot(Serializable serializable, EntityPersister entityPersister) throws HibernateException {
        if (!entityPersister.hasNaturalIdentifier()) {
            return null;
        }
        Object[] objectArray = this.naturalIdHelper.findCachedNaturalId(entityPersister = this.locateProperPersister(entityPersister), serializable);
        if (objectArray != null) {
            return objectArray;
        }
        if (entityPersister.getEntityMetamodel().hasImmutableNaturalId()) {
            Object[] objectArray2 = entityPersister.getNaturalIdentifierSnapshot(serializable, this.session);
            this.naturalIdHelper.cacheNaturalIdCrossReferenceFromLoad(entityPersister, serializable, objectArray2);
            return objectArray2;
        }
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        Object[] objectArray3 = this.getDatabaseSnapshot(serializable, entityPersister);
        if (objectArray3 == NO_ROW) {
            return null;
        }
        Object[] objectArray4 = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray4[i] = objectArray3[nArray[i]];
        }
        this.naturalIdHelper.cacheNaturalIdCrossReferenceFromLoad(entityPersister, serializable, objectArray4);
        return objectArray4;
    }

    private EntityPersister locateProperPersister(EntityPersister entityPersister) {
        return this.session.getFactory().getEntityPersister(entityPersister.getRootEntityName());
    }

    @Override
    public Object[] getCachedDatabaseSnapshot(EntityKey entityKey) {
        Object object = this.entitySnapshotsByKey.get(entityKey);
        if (object == NO_ROW) {
            throw new IllegalStateException("persistence context reported no row snapshot for " + MessageHelper.infoString(entityKey.getEntityName(), entityKey.getIdentifier()));
        }
        return (Object[])object;
    }

    @Override
    public void addEntity(EntityKey entityKey, Object object) {
        this.entitiesByKey.put(entityKey, object);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
    }

    @Override
    public Object getEntity(EntityKey entityKey) {
        return this.entitiesByKey.get(entityKey);
    }

    @Override
    public boolean containsEntity(EntityKey entityKey) {
        return this.entitiesByKey.containsKey(entityKey);
    }

    @Override
    public Object removeEntity(EntityKey entityKey) {
        Object object = this.entitiesByKey.remove(entityKey);
        Iterator<Object> iterator = this.entitiesByUniqueKey.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != object) continue;
            iterator.remove();
        }
        this.parentsByChild.clear();
        this.entitySnapshotsByKey.remove(entityKey);
        this.nullifiableEntityKeys.remove(entityKey);
        this.getBatchFetchQueue().removeBatchLoadableEntityKey(entityKey);
        this.getBatchFetchQueue().removeSubselect(entityKey);
        return object;
    }

    @Override
    public Object getEntity(EntityUniqueKey entityUniqueKey) {
        return this.entitiesByUniqueKey.get(entityUniqueKey);
    }

    @Override
    public void addEntity(EntityUniqueKey entityUniqueKey, Object object) {
        this.entitiesByUniqueKey.put(entityUniqueKey, object);
    }

    @Override
    public EntityEntry getEntry(Object object) {
        return this.entityEntryContext.getEntityEntry(object);
    }

    @Override
    public EntityEntry removeEntry(Object object) {
        return this.entityEntryContext.removeEntityEntry(object);
    }

    @Override
    public boolean isEntryFor(Object object) {
        return this.entityEntryContext.hasEntityEntry(object);
    }

    @Override
    public CollectionEntry getCollectionEntry(PersistentCollection persistentCollection) {
        return this.collectionEntries.get(persistentCollection);
    }

    @Override
    public EntityEntry addEntity(Object object, Status status, Object[] objectArray, EntityKey entityKey, Object object2, LockMode lockMode, boolean bl, EntityPersister entityPersister, boolean bl2, boolean bl3) {
        this.addEntity(entityKey, object);
        return this.addEntry(object, status, objectArray, null, entityKey.getIdentifier(), object2, lockMode, bl, entityPersister, bl2, bl3);
    }

    @Override
    public EntityEntry addEntry(Object object, Status status, Object[] objectArray, Object object2, Serializable serializable, Object object3, LockMode lockMode, boolean bl, EntityPersister entityPersister, boolean bl2, boolean bl3) {
        EntityEntry entityEntry = new EntityEntry(status, objectArray, object2, serializable, object3, lockMode, bl, entityPersister, entityPersister.getEntityMode(), this.session.getTenantIdentifier(), bl2, bl3, this);
        this.entityEntryContext.addEntityEntry(object, entityEntry);
        this.setHasNonReadOnlyEnties(status);
        return entityEntry;
    }

    @Override
    public boolean containsCollection(PersistentCollection persistentCollection) {
        return this.collectionEntries.containsKey(persistentCollection);
    }

    @Override
    public boolean containsProxy(Object object) {
        return this.proxiesByKey.containsValue(object);
    }

    @Override
    public boolean reassociateIfUninitializedProxy(Object object) throws MappingException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (!Hibernate.isInitialized(object)) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            this.reassociateProxy(lazyInitializer, hibernateProxy);
            return true;
        }
        return false;
    }

    @Override
    public void reassociateProxy(Object object, Serializable serializable) throws MappingException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            LOG.debugf("Setting proxy identifier: %s", (Object)serializable);
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            lazyInitializer.setIdentifier(serializable);
            this.reassociateProxy(lazyInitializer, hibernateProxy);
        }
    }

    private void reassociateProxy(LazyInitializer lazyInitializer, HibernateProxy hibernateProxy) {
        if (lazyInitializer.getSession() != this.getSession()) {
            EntityPersister entityPersister = this.session.getFactory().getEntityPersister(lazyInitializer.getEntityName());
            EntityKey entityKey = this.session.generateEntityKey(lazyInitializer.getIdentifier(), entityPersister);
            if (!this.proxiesByKey.containsKey(entityKey)) {
                this.proxiesByKey.put(entityKey, hibernateProxy);
            }
            hibernateProxy.getHibernateLazyInitializer().setSession(this.session);
        }
    }

    @Override
    public Object unproxy(Object object) throws HibernateException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            if (lazyInitializer.isUninitialized()) {
                throw new PersistentObjectException("object was an uninitialized proxy for " + lazyInitializer.getEntityName());
            }
            return lazyInitializer.getImplementation();
        }
        return object;
    }

    @Override
    public Object unproxyAndReassociate(Object object) throws HibernateException {
        if (object instanceof ElementWrapper) {
            object = ((ElementWrapper)object).getElement();
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            LazyInitializer lazyInitializer = hibernateProxy.getHibernateLazyInitializer();
            this.reassociateProxy(lazyInitializer, hibernateProxy);
            return lazyInitializer.getImplementation();
        }
        return object;
    }

    @Override
    public void checkUniqueness(EntityKey entityKey, Object object) throws HibernateException {
        Object object2 = this.getEntity(entityKey);
        if (object2 == object) {
            throw new AssertionFailure("object already associated, but no entry was found");
        }
        if (object2 != null) {
            throw new NonUniqueObjectException(entityKey.getIdentifier(), entityKey.getEntityName());
        }
    }

    @Override
    public Object narrowProxy(Object object, EntityPersister entityPersister, EntityKey entityKey, Object object2) throws HibernateException {
        Class clazz = entityPersister.getConcreteProxyClass();
        boolean bl = clazz.isAssignableFrom(object.getClass());
        if (!bl) {
            LOG.narrowingProxy(clazz);
            if (object2 != null) {
                this.proxiesByKey.remove(entityKey);
                return object2;
            }
            object = entityPersister.createProxy(entityKey.getIdentifier(), this.session);
            Object object3 = this.proxiesByKey.put(entityKey, object);
            if (object3 != null) {
                if (!(object3 instanceof HibernateProxy)) {
                    throw new AssertionFailure("proxy not of type HibernateProxy; it is " + object3.getClass());
                }
                boolean bl2 = ((HibernateProxy)object3).getHibernateLazyInitializer().isReadOnly();
                ((HibernateProxy)object).getHibernateLazyInitializer().setReadOnly(bl2);
            }
            return object;
        }
        if (object2 != null) {
            LazyInitializer lazyInitializer = ((HibernateProxy)object).getHibernateLazyInitializer();
            lazyInitializer.setImplementation(object2);
        }
        return object;
    }

    @Override
    public Object proxyFor(EntityPersister entityPersister, EntityKey entityKey, Object object) throws HibernateException {
        if (!entityPersister.hasProxy()) {
            return object;
        }
        Object object2 = this.proxiesByKey.get(entityKey);
        return object2 != null ? this.narrowProxy(object2, entityPersister, entityKey, object) : object;
    }

    @Override
    public Object proxyFor(Object object) throws HibernateException {
        EntityEntry entityEntry = this.getEntry(object);
        return this.proxyFor(entityEntry.getPersister(), entityEntry.getEntityKey(), object);
    }

    @Override
    public Object getCollectionOwner(Serializable serializable, CollectionPersister collectionPersister) throws MappingException {
        EntityPersister entityPersister = collectionPersister.getOwnerEntityPersister();
        if (entityPersister.getIdentifierType().getReturnedClass().isInstance(serializable)) {
            return this.getEntity(this.session.generateEntityKey(serializable, collectionPersister.getOwnerEntityPersister()));
        }
        if (entityPersister.isInstance(serializable)) {
            Serializable serializable2 = entityPersister.getIdentifier(serializable, this.session);
            if (serializable2 == null) {
                return null;
            }
            return this.getEntity(this.session.generateEntityKey(serializable2, entityPersister));
        }
        CollectionType collectionType = collectionPersister.getCollectionType();
        if (collectionType.getLHSPropertyName() != null) {
            Object object = this.getEntity(new EntityUniqueKey(entityPersister.getEntityName(), collectionType.getLHSPropertyName(), serializable, collectionPersister.getKeyType(), entityPersister.getEntityMode(), this.session.getFactory()));
            if (object != null) {
                return object;
            }
            Serializable serializable3 = entityPersister.getIdByUniqueKey(serializable, collectionType.getLHSPropertyName(), this.session);
            return this.getEntity(this.session.generateEntityKey(serializable3, entityPersister));
        }
        return this.getEntity(this.session.generateEntityKey(serializable, collectionPersister.getOwnerEntityPersister()));
    }

    @Override
    public Object getLoadedCollectionOwnerOrNull(PersistentCollection persistentCollection) {
        CollectionEntry collectionEntry = this.getCollectionEntry(persistentCollection);
        if (collectionEntry.getLoadedPersister() == null) {
            return null;
        }
        Object object = null;
        Serializable serializable = this.getLoadedCollectionOwnerIdOrNull(collectionEntry);
        if (serializable != null) {
            object = this.getCollectionOwner(serializable, collectionEntry.getLoadedPersister());
        }
        return object;
    }

    @Override
    public Serializable getLoadedCollectionOwnerIdOrNull(PersistentCollection persistentCollection) {
        return this.getLoadedCollectionOwnerIdOrNull(this.getCollectionEntry(persistentCollection));
    }

    private Serializable getLoadedCollectionOwnerIdOrNull(CollectionEntry collectionEntry) {
        if (collectionEntry == null || collectionEntry.getLoadedKey() == null || collectionEntry.getLoadedPersister() == null) {
            return null;
        }
        return collectionEntry.getLoadedPersister().getCollectionType().getIdOfOwnerOrNull(collectionEntry.getLoadedKey(), this.session);
    }

    @Override
    public void addUninitializedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable) {
        CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, collectionPersister, serializable, this.flushing);
        this.addCollection(persistentCollection, collectionEntry, serializable);
        if (collectionPersister.getBatchSize() > 1) {
            this.getBatchFetchQueue().addBatchLoadableCollection(persistentCollection, collectionEntry);
        }
    }

    @Override
    public void addUninitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) {
        CollectionEntry collectionEntry = new CollectionEntry(collectionPersister, persistentCollection.getKey());
        this.addCollection(persistentCollection, collectionEntry, persistentCollection.getKey());
        if (collectionPersister.getBatchSize() > 1) {
            this.getBatchFetchQueue().addBatchLoadableCollection(persistentCollection, collectionEntry);
        }
    }

    @Override
    public void addNewCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) throws HibernateException {
        this.addCollection(persistentCollection, collectionPersister);
    }

    private void addCollection(PersistentCollection persistentCollection, CollectionEntry collectionEntry, Serializable serializable) {
        this.collectionEntries.put(persistentCollection, collectionEntry);
        CollectionKey collectionKey = new CollectionKey(collectionEntry.getLoadedPersister(), serializable);
        PersistentCollection persistentCollection2 = this.collectionsByKey.put(collectionKey, persistentCollection);
        if (persistentCollection2 != null) {
            if (persistentCollection2 == persistentCollection) {
                throw new AssertionFailure("bug adding collection twice");
            }
            persistentCollection2.unsetSession(this.session);
            this.collectionEntries.remove(persistentCollection2);
        }
    }

    private void addCollection(PersistentCollection persistentCollection, CollectionPersister collectionPersister) {
        CollectionEntry collectionEntry = new CollectionEntry(collectionPersister, persistentCollection);
        this.collectionEntries.put(persistentCollection, collectionEntry);
    }

    @Override
    public void addInitializedDetachedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection) throws HibernateException {
        if (persistentCollection.isUnreferenced()) {
            this.addCollection(persistentCollection, collectionPersister);
        } else {
            CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, this.session.getFactory());
            this.addCollection(persistentCollection, collectionEntry, persistentCollection.getKey());
        }
    }

    @Override
    public CollectionEntry addInitializedCollection(CollectionPersister collectionPersister, PersistentCollection persistentCollection, Serializable serializable) throws HibernateException {
        CollectionEntry collectionEntry = new CollectionEntry(persistentCollection, collectionPersister, serializable, this.flushing);
        collectionEntry.postInitialize(persistentCollection);
        this.addCollection(persistentCollection, collectionEntry, serializable);
        return collectionEntry;
    }

    @Override
    public PersistentCollection getCollection(CollectionKey collectionKey) {
        return this.collectionsByKey.get(collectionKey);
    }

    @Override
    public void addNonLazyCollection(PersistentCollection persistentCollection) {
        this.nonlazyCollections.add(persistentCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeNonLazyCollections() throws HibernateException {
        if (this.loadCounter == 0) {
            if (tracing) {
                LOG.trace("Initializing non-lazy collections");
            }
            ++this.loadCounter;
            try {
                int n;
                while ((n = this.nonlazyCollections.size()) > 0) {
                    this.nonlazyCollections.remove(n - 1).forceInitialization();
                }
            }
            finally {
                --this.loadCounter;
                this.clearNullProperties();
            }
        }
    }

    @Override
    public PersistentCollection getCollectionHolder(Object object) {
        return this.arrayHolders.get(object);
    }

    @Override
    public void addCollectionHolder(PersistentCollection persistentCollection) {
        this.arrayHolders.put(persistentCollection.getValue(), persistentCollection);
    }

    @Override
    public PersistentCollection removeCollectionHolder(Object object) {
        return this.arrayHolders.remove(object);
    }

    @Override
    public Serializable getSnapshot(PersistentCollection persistentCollection) {
        return this.getCollectionEntry(persistentCollection).getSnapshot();
    }

    @Override
    public CollectionEntry getCollectionEntryOrNull(Object object) {
        PersistentCollection persistentCollection;
        if (object instanceof PersistentCollection) {
            persistentCollection = (PersistentCollection)object;
        } else {
            persistentCollection = this.getCollectionHolder(object);
            if (persistentCollection == null) {
                Iterator<PersistentCollection> iterator = this.collectionEntries.keyIterator();
                while (iterator.hasNext()) {
                    PersistentCollection persistentCollection2 = iterator.next();
                    if (!persistentCollection2.isWrapper(object)) continue;
                    persistentCollection = persistentCollection2;
                    break;
                }
            }
        }
        return persistentCollection == null ? null : this.getCollectionEntry(persistentCollection);
    }

    @Override
    public Object getProxy(EntityKey entityKey) {
        return this.proxiesByKey.get(entityKey);
    }

    @Override
    public void addProxy(EntityKey entityKey, Object object) {
        this.proxiesByKey.put(entityKey, object);
    }

    @Override
    public Object removeProxy(EntityKey entityKey) {
        if (this.batchFetchQueue != null) {
            this.batchFetchQueue.removeBatchLoadableEntityKey(entityKey);
            this.batchFetchQueue.removeSubselect(entityKey);
        }
        return this.proxiesByKey.remove(entityKey);
    }

    @Override
    public HashSet getNullifiableEntityKeys() {
        return this.nullifiableEntityKeys;
    }

    @Override
    public Map getEntitiesByKey() {
        return this.entitiesByKey;
    }

    public Map getProxiesByKey() {
        return this.proxiesByKey;
    }

    @Override
    public int getNumberOfManagedEntities() {
        return this.entityEntryContext.getNumberOfManagedEntities();
    }

    @Override
    public Map getEntityEntries() {
        return null;
    }

    @Override
    public Map getCollectionEntries() {
        return this.collectionEntries;
    }

    @Override
    public Map getCollectionsByKey() {
        return this.collectionsByKey;
    }

    @Override
    public int getCascadeLevel() {
        return this.cascading;
    }

    @Override
    public int incrementCascadeLevel() {
        return ++this.cascading;
    }

    @Override
    public int decrementCascadeLevel() {
        return --this.cascading;
    }

    @Override
    public boolean isFlushing() {
        return this.flushing;
    }

    @Override
    public void setFlushing(boolean bl) {
        boolean bl2 = this.flushing && !bl;
        this.flushing = bl;
        if (bl2) {
            this.getNaturalIdHelper().cleanupFromSynchronizations();
        }
    }

    @Override
    public void beforeLoad() {
        ++this.loadCounter;
    }

    @Override
    public void afterLoad() {
        --this.loadCounter;
    }

    @Override
    public boolean isLoadFinished() {
        return this.loadCounter == 0;
    }

    @Override
    public String toString() {
        return "PersistenceContext[entityKeys=" + this.entitiesByKey.keySet() + ",collectionKeys=" + this.collectionsByKey.keySet() + "]";
    }

    @Override
    public Map.Entry<Object, EntityEntry>[] reentrantSafeEntityEntries() {
        return this.entityEntryContext.reentrantSafeEntityEntries();
    }

    @Override
    public Serializable getOwnerId(String string, String string2, Object object, Map map) {
        String string3 = string + '.' + string2;
        EntityPersister entityPersister = this.session.getFactory().getEntityPersister(string);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(string3);
        Object object2 = this.parentsByChild.get(object);
        if (object2 != null) {
            EntityEntry entityEntry = this.entityEntryContext.getEntityEntry(object2);
            if (entityPersister.isSubclassEntityName(entityEntry.getEntityName()) && this.isFoundInParent(string2, object, entityPersister, collectionPersister, object2)) {
                return this.getEntry(object2).getId();
            }
            this.parentsByChild.remove(object);
        }
        for (Map.Entry<Object, EntityEntry> object3 : this.reentrantSafeEntityEntries()) {
            EntityEntry entityEntry = (EntityEntry)object3.getValue();
            if (!entityPersister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object k = object3.getKey();
            boolean bl = this.isFoundInParent(string2, object, entityPersister, collectionPersister, k);
            if (!bl && map != null) {
                Object v = map.get(k);
                Object v2 = map.get(object);
                if (v != null && v2 != null) {
                    bl = this.isFoundInParent(string2, v2, entityPersister, collectionPersister, v);
                }
            }
            if (!bl) continue;
            return entityEntry.getId();
        }
        if (map != null) {
            for (Object e : map.entrySet()) {
                HibernateProxy hibernateProxy;
                Map.Entry entry = (Map.Entry)e;
                if (!(entry.getKey() instanceof HibernateProxy) || !entityPersister.isSubclassEntityName((hibernateProxy = (HibernateProxy)entry.getKey()).getHibernateLazyInitializer().getEntityName())) continue;
                boolean bl = this.isFoundInParent(string2, object, entityPersister, collectionPersister, map.get(hibernateProxy));
                if (!bl) {
                    bl = this.isFoundInParent(string2, map.get(object), entityPersister, collectionPersister, map.get(hibernateProxy));
                }
                if (!bl) continue;
                return hibernateProxy.getHibernateLazyInitializer().getIdentifier();
            }
        }
        return null;
    }

    private boolean isFoundInParent(String string, Object object, EntityPersister entityPersister, CollectionPersister collectionPersister, Object object2) {
        Object object3 = entityPersister.getPropertyValue(object2, string);
        return object3 != null && Hibernate.isInitialized(object3) && collectionPersister.getCollectionType().contains(object3, object, this.session);
    }

    @Override
    public Object getIndexInOwner(String string, String string2, Object object, Map map) {
        EntityPersister entityPersister = this.session.getFactory().getEntityPersister(string);
        CollectionPersister collectionPersister = this.session.getFactory().getCollectionPersister(string + '.' + string2);
        Object object2 = this.parentsByChild.get(object);
        if (object2 != null) {
            EntityEntry entityEntry = this.entityEntryContext.getEntityEntry(object2);
            if (entityPersister.isSubclassEntityName(entityEntry.getEntityName())) {
                Object object3 = this.getIndexInParent(string2, object, entityPersister, collectionPersister, object2);
                if (object3 == null && map != null) {
                    Object v = map.get(object2);
                    Object object4 = map.get(object);
                    if (v != null && object4 != null) {
                        object3 = this.getIndexInParent(string2, object4, entityPersister, collectionPersister, v);
                    }
                }
                if (object3 != null) {
                    return object3;
                }
            } else {
                this.parentsByChild.remove(object);
            }
        }
        for (Map.Entry<Object, EntityEntry> entry : this.reentrantSafeEntityEntries()) {
            EntityEntry entityEntry = (EntityEntry)entry.getValue();
            if (!entityPersister.isSubclassEntityName(entityEntry.getEntityName())) continue;
            Object k = entry.getKey();
            Object object3 = this.getIndexInParent(string2, object, entityPersister, collectionPersister, k);
            if (object3 == null && map != null) {
                Object v = map.get(k);
                Object v2 = map.get(object);
                if (v != null && v2 != null) {
                    object3 = this.getIndexInParent(string2, v2, entityPersister, collectionPersister, v);
                }
            }
            if (object3 == null) continue;
            return object3;
        }
        return null;
    }

    private Object getIndexInParent(String string, Object object, EntityPersister entityPersister, CollectionPersister collectionPersister, Object object2) {
        Object object3 = entityPersister.getPropertyValue(object2, string);
        if (object3 != null && Hibernate.isInitialized(object3)) {
            return collectionPersister.getCollectionType().indexOf(object3, object);
        }
        return null;
    }

    @Override
    public void addNullProperty(EntityKey entityKey, String string) {
        this.nullAssociations.add(new AssociationKey(entityKey, string));
    }

    @Override
    public boolean isPropertyNull(EntityKey entityKey, String string) {
        return this.nullAssociations.contains(new AssociationKey(entityKey, string));
    }

    private void clearNullProperties() {
        this.nullAssociations.clear();
    }

    @Override
    public boolean isReadOnly(Object object) {
        boolean bl;
        if (object == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (object instanceof HibernateProxy) {
            bl = ((HibernateProxy)object).getHibernateLazyInitializer().isReadOnly();
        } else {
            EntityEntry entityEntry = this.getEntry(object);
            if (entityEntry == null) {
                throw new TransientObjectException("Instance was not associated with this persistence context");
            }
            bl = entityEntry.isReadOnly();
        }
        return bl;
    }

    @Override
    public void setReadOnly(Object object, boolean bl) {
        if (object == null) {
            throw new AssertionFailure("object must be non-null.");
        }
        if (this.isReadOnly(object) == bl) {
            return;
        }
        if (object instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)object;
            this.setProxyReadOnly(hibernateProxy, bl);
            if (Hibernate.isInitialized(hibernateProxy)) {
                this.setEntityReadOnly(hibernateProxy.getHibernateLazyInitializer().getImplementation(), bl);
            }
        } else {
            this.setEntityReadOnly(object, bl);
            Object object2 = this.getSession().getPersistenceContext().proxyFor(object);
            if (object2 instanceof HibernateProxy) {
                this.setProxyReadOnly((HibernateProxy)object2, bl);
            }
        }
    }

    private void setProxyReadOnly(HibernateProxy hibernateProxy, boolean bl) {
        if (hibernateProxy.getHibernateLazyInitializer().getSession() != this.getSession()) {
            throw new AssertionFailure("Attempt to set a proxy to read-only that is associated with a different session");
        }
        hibernateProxy.getHibernateLazyInitializer().setReadOnly(bl);
    }

    private void setEntityReadOnly(Object object, boolean bl) {
        EntityEntry entityEntry = this.getEntry(object);
        if (entityEntry == null) {
            throw new TransientObjectException("Instance was not associated with this persistence context");
        }
        entityEntry.setReadOnly(bl, object);
        this.hasNonReadOnlyEntities = this.hasNonReadOnlyEntities || !bl;
    }

    @Override
    public void replaceDelayedEntityIdentityInsertKeys(EntityKey entityKey, Serializable serializable) {
        Object object = this.entitiesByKey.remove(entityKey);
        EntityEntry entityEntry = this.entityEntryContext.removeEntityEntry(object);
        this.parentsByChild.clear();
        EntityKey entityKey2 = this.session.generateEntityKey(serializable, entityEntry.getPersister());
        this.addEntity(entityKey2, object);
        this.addEntry(object, entityEntry.getStatus(), entityEntry.getLoadedState(), entityEntry.getRowId(), serializable, entityEntry.getVersion(), entityEntry.getLockMode(), entityEntry.isExistsInDatabase(), entityEntry.getPersister(), entityEntry.isBeingReplicated(), entityEntry.isLoadedWithLazyPropertiesUnfetched());
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = LOG.isTraceEnabled();
        if (bl) {
            LOG.trace("Serializing persistent-context");
        }
        objectOutputStream.writeBoolean(this.defaultReadOnly);
        objectOutputStream.writeBoolean(this.hasNonReadOnlyEntities);
        objectOutputStream.writeInt(this.entitiesByKey.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.entitiesByKey.size() + "] entitiesByKey entries");
        }
        for (Map.Entry<EntityKey, Object> object : this.entitiesByKey.entrySet()) {
            object.getKey().serialize(objectOutputStream);
            objectOutputStream.writeObject(object.getValue());
        }
        objectOutputStream.writeInt(this.entitiesByUniqueKey.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.entitiesByUniqueKey.size() + "] entitiesByUniqueKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.entitiesByUniqueKey.entrySet()) {
            ((EntityUniqueKey)entry.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeInt(this.proxiesByKey.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.proxiesByKey.size() + "] proxiesByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.proxiesByKey.entrySet()) {
            ((EntityKey)entry.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeInt(this.entitySnapshotsByKey.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.entitySnapshotsByKey.size() + "] entitySnapshotsByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.entitySnapshotsByKey.entrySet()) {
            ((EntityKey)entry.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(entry.getValue());
        }
        this.entityEntryContext.serialize(objectOutputStream);
        objectOutputStream.writeInt(this.collectionsByKey.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.collectionsByKey.size() + "] collectionsByKey entries");
        }
        for (Map.Entry<Serializable, Object> entry : this.collectionsByKey.entrySet()) {
            ((CollectionKey)entry.getKey()).serialize(objectOutputStream);
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeInt(this.collectionEntries.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.collectionEntries.size() + "] collectionEntries entries");
        }
        for (Map.Entry<Object, Object> entry : this.collectionEntries.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            ((CollectionEntry)entry.getValue()).serialize(objectOutputStream);
        }
        objectOutputStream.writeInt(this.arrayHolders.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.arrayHolders.size() + "] arrayHolders entries");
        }
        for (Map.Entry<Object, Object> entry : this.arrayHolders.entrySet()) {
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
        objectOutputStream.writeInt(this.nullifiableEntityKeys.size());
        if (bl) {
            LOG.trace("Starting serialization of [" + this.nullifiableEntityKeys.size() + "] nullifiableEntityKey entries");
        }
        for (EntityKey entityKey : this.nullifiableEntityKeys) {
            entityKey.serialize(objectOutputStream);
        }
    }

    public static StatefulPersistenceContext deserialize(ObjectInputStream objectInputStream, SessionImplementor sessionImplementor) throws IOException, ClassNotFoundException {
        boolean bl = LOG.isTraceEnabled();
        if (bl) {
            LOG.trace("Serializing persistent-context");
        }
        StatefulPersistenceContext statefulPersistenceContext = new StatefulPersistenceContext(sessionImplementor);
        try {
            Object object;
            Object object2;
            int n;
            statefulPersistenceContext.defaultReadOnly = objectInputStream.readBoolean();
            statefulPersistenceContext.hasNonReadOnlyEntities = objectInputStream.readBoolean();
            int n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] entitiesByKey entries");
            }
            statefulPersistenceContext.entitiesByKey = new HashMap<EntityKey, Object>(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitiesByKey.put(EntityKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] entitiesByUniqueKey entries");
            }
            statefulPersistenceContext.entitiesByUniqueKey = new HashMap<EntityUniqueKey, Object>(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitiesByUniqueKey.put(EntityUniqueKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] proxiesByKey entries");
            }
            statefulPersistenceContext.proxiesByKey = new ConcurrentReferenceHashMap<EntityKey, Object>(n2 < 8 ? 8 : n2, 0.75f, 1, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, null);
            for (n = 0; n < n2; ++n) {
                object2 = EntityKey.deserialize(objectInputStream, sessionImplementor);
                object = objectInputStream.readObject();
                if (object instanceof HibernateProxy) {
                    ((HibernateProxy)object).getHibernateLazyInitializer().setSession(sessionImplementor);
                    statefulPersistenceContext.proxiesByKey.put((EntityKey)object2, object);
                    continue;
                }
                if (!bl) continue;
                LOG.trace("Encountered prunded proxy");
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] entitySnapshotsByKey entries");
            }
            statefulPersistenceContext.entitySnapshotsByKey = new HashMap<EntityKey, Object>(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.entitySnapshotsByKey.put(EntityKey.deserialize(objectInputStream, sessionImplementor), objectInputStream.readObject());
            }
            statefulPersistenceContext.entityEntryContext = EntityEntryContext.deserialize(objectInputStream, statefulPersistenceContext);
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] collectionsByKey entries");
            }
            statefulPersistenceContext.collectionsByKey = new HashMap<CollectionKey, PersistentCollection>(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.collectionsByKey.put(CollectionKey.deserialize(objectInputStream, sessionImplementor), (PersistentCollection)objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] collectionEntries entries");
            }
            statefulPersistenceContext.collectionEntries = IdentityMap.instantiateSequenced(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                object2 = (PersistentCollection)objectInputStream.readObject();
                object = CollectionEntry.deserialize(objectInputStream, sessionImplementor);
                object2.setCurrentSession(sessionImplementor);
                statefulPersistenceContext.collectionEntries.put((PersistentCollection)object2, (CollectionEntry)object);
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] arrayHolders entries");
            }
            statefulPersistenceContext.arrayHolders = new IdentityHashMap<Object, PersistentCollection>(n2 < 8 ? 8 : n2);
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.arrayHolders.put(objectInputStream.readObject(), (PersistentCollection)objectInputStream.readObject());
            }
            n2 = objectInputStream.readInt();
            if (bl) {
                LOG.trace("Starting deserialization of [" + n2 + "] nullifiableEntityKey entries");
            }
            statefulPersistenceContext.nullifiableEntityKeys = new HashSet();
            for (n = 0; n < n2; ++n) {
                statefulPersistenceContext.nullifiableEntityKeys.add(EntityKey.deserialize(objectInputStream, sessionImplementor));
            }
        }
        catch (HibernateException hibernateException) {
            throw new InvalidObjectException(hibernateException.getMessage());
        }
        return statefulPersistenceContext;
    }

    @Override
    public void addChildParent(Object object, Object object2) {
        this.parentsByChild.put(object, object2);
    }

    @Override
    public void removeChildParent(Object object) {
        this.parentsByChild.remove(object);
    }

    @Override
    public void registerInsertedKey(EntityPersister entityPersister, Serializable serializable) {
        if (entityPersister.hasCache()) {
            String string;
            List<Serializable> list;
            if (this.insertedKeysMap == null) {
                this.insertedKeysMap = new HashMap();
            }
            if ((list = this.insertedKeysMap.get(string = entityPersister.getRootEntityName())) == null) {
                list = new ArrayList<Serializable>();
                this.insertedKeysMap.put(string, list);
            }
            list.add(serializable);
        }
    }

    @Override
    public boolean wasInsertedDuringTransaction(EntityPersister entityPersister, Serializable serializable) {
        List<Serializable> list;
        if (entityPersister.hasCache() && this.insertedKeysMap != null && (list = this.insertedKeysMap.get(entityPersister.getRootEntityName())) != null) {
            return list.contains(serializable);
        }
        return false;
    }

    private void cleanUpInsertedKeysAfterTransaction() {
        if (this.insertedKeysMap != null) {
            this.insertedKeysMap.clear();
        }
    }

    @Override
    public PersistenceContext.NaturalIdHelper getNaturalIdHelper() {
        return this.naturalIdHelper;
    }

    private Object[] getNaturalIdValues(Object[] objectArray, EntityPersister entityPersister) {
        int[] nArray = entityPersister.getNaturalIdentifierProperties();
        Object[] objectArray2 = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray2[i] = objectArray[nArray[i]];
        }
        return objectArray2;
    }
}

