/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.Iterator;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public final class Nullability {
    private final SessionImplementor session;
    private final boolean checkNullability;

    public Nullability(SessionImplementor sessionImplementor) {
        this.session = sessionImplementor;
        this.checkNullability = sessionImplementor.getFactory().getSettings().isCheckNullability();
    }

    public void checkNullability(Object[] objectArray, EntityPersister entityPersister, boolean bl) throws PropertyValueException, HibernateException {
        if (this.checkNullability) {
            boolean[] blArray = entityPersister.getPropertyNullability();
            boolean[] blArray2 = bl ? entityPersister.getPropertyUpdateability() : entityPersister.getPropertyInsertability();
            Type[] typeArray = entityPersister.getPropertyTypes();
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                if (!blArray2[i] || objectArray[i] == LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
                Object object = objectArray[i];
                if (!blArray[i] && object == null) {
                    throw new PropertyValueException("not-null property references a null or transient value", entityPersister.getEntityName(), entityPersister.getPropertyNames()[i]);
                }
                if (object == null || (string = this.checkSubElementsNullability(typeArray[i], object)) == null) continue;
                throw new PropertyValueException("not-null property references a null or transient value", entityPersister.getEntityName(), Nullability.buildPropertyPath(entityPersister.getPropertyNames()[i], string));
            }
        }
    }

    private String checkSubElementsNullability(Type type, Object object) throws HibernateException {
        CollectionType collectionType;
        Type type2;
        if (type.isComponentType()) {
            return this.checkComponentNullability(object, (CompositeType)type);
        }
        if (type.isCollectionType() && (type2 = (collectionType = (CollectionType)type).getElementType(this.session.getFactory())).isComponentType()) {
            CompositeType compositeType = (CompositeType)type2;
            Iterator iterator = CascadingAction.getLoadedElementsIterator(this.session, collectionType, object);
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null) continue;
                return this.checkComponentNullability(e, compositeType);
            }
        }
        return null;
    }

    private String checkComponentNullability(Object object, CompositeType compositeType) throws HibernateException {
        boolean[] blArray = compositeType.getPropertyNullability();
        if (blArray != null) {
            Object[] objectArray = compositeType.getPropertyValues(object, EntityMode.POJO);
            Type[] typeArray = compositeType.getSubtypes();
            for (int i = 0; i < objectArray.length; ++i) {
                String string;
                Object object2 = objectArray[i];
                if (!blArray[i] && object2 == null) {
                    return compositeType.getPropertyNames()[i];
                }
                if (object2 == null || (string = this.checkSubElementsNullability(typeArray[i], object2)) == null) continue;
                return Nullability.buildPropertyPath(compositeType.getPropertyNames()[i], string);
            }
        }
        return null;
    }

    private static String buildPropertyPath(String string, String string2) {
        return new StringBuilder(string.length() + string2.length() + 1).append(string).append('.').append(string2).toString();
    }
}

