/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.hibernate.engine.spi.SessionImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonNullableTransientDependencies {
    private final Map<Object, Set<String>> propertyPathsByTransientEntity = new IdentityHashMap<Object, Set<String>>();

    void add(String string, Object object) {
        Set<String> set = this.propertyPathsByTransientEntity.get(object);
        if (set == null) {
            set = new HashSet<String>();
            this.propertyPathsByTransientEntity.put(object, set);
        }
        set.add(string);
    }

    public Iterable<Object> getNonNullableTransientEntities() {
        return this.propertyPathsByTransientEntity.keySet();
    }

    public Iterable<String> getNonNullableTransientPropertyPaths(Object object) {
        return this.propertyPathsByTransientEntity.get(object);
    }

    public boolean isEmpty() {
        return this.propertyPathsByTransientEntity.isEmpty();
    }

    public void resolveNonNullableTransientEntity(Object object) {
        if (this.propertyPathsByTransientEntity.remove(object) == null) {
            throw new IllegalStateException("Attempt to resolve a non-nullable, transient entity that is not a dependency.");
        }
    }

    public String toLoggableString(SessionImplementor sessionImplementor) {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append('[');
        for (Map.Entry<Object, Set<String>> entry : this.propertyPathsByTransientEntity.entrySet()) {
            stringBuilder.append("transientEntityName=").append(sessionImplementor.bestGuessEntityName(entry.getKey()));
            stringBuilder.append(" requiredBy=").append(entry.getValue());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

