/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaturalIdXrefDelegate {
    private static final Logger LOG = Logger.getLogger(NaturalIdXrefDelegate.class);
    private final StatefulPersistenceContext persistenceContext;
    private final Map<EntityPersister, NaturalIdResolutionCache> naturalIdResolutionCacheMap = new ConcurrentHashMap<EntityPersister, NaturalIdResolutionCache>();

    public NaturalIdXrefDelegate(StatefulPersistenceContext statefulPersistenceContext) {
        this.persistenceContext = statefulPersistenceContext;
    }

    protected SessionImplementor session() {
        return this.persistenceContext.getSession();
    }

    public boolean cacheNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
        this.validateNaturalId(entityPersister, objectArray);
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister);
        if (naturalIdResolutionCache == null) {
            naturalIdResolutionCache = new NaturalIdResolutionCache(entityPersister);
            this.naturalIdResolutionCacheMap.put(entityPersister, naturalIdResolutionCache);
        }
        return naturalIdResolutionCache.cache(serializable, objectArray);
    }

    public Object[] removeNaturalIdCrossReference(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
        Object object;
        entityPersister = this.locatePersisterForKey(entityPersister);
        this.validateNaturalId(entityPersister, objectArray);
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister);
        Object[] objectArray2 = null;
        if (naturalIdResolutionCache != null && (object = (CachedNaturalId)naturalIdResolutionCache.pkToNaturalIdMap.remove(serializable)) != null) {
            naturalIdResolutionCache.naturalIdToPkMap.remove(object);
            objectArray2 = ((CachedNaturalId)object).getValues();
        }
        if (entityPersister.hasNaturalIdCache()) {
            object = entityPersister.getNaturalIdCacheAccessStrategy();
            NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(objectArray, entityPersister, this.session());
            object.evict(naturalIdCacheKey);
            if (objectArray2 != null && !Arrays.equals(objectArray2, objectArray)) {
                NaturalIdCacheKey naturalIdCacheKey2 = new NaturalIdCacheKey(objectArray2, entityPersister, this.session());
                object.evict(naturalIdCacheKey2);
            }
        }
        return objectArray2;
    }

    public boolean sameAsCached(EntityPersister entityPersister, Serializable serializable, Object[] objectArray) {
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister);
        return naturalIdResolutionCache != null && naturalIdResolutionCache.sameAsCached(serializable, objectArray);
    }

    protected EntityPersister locatePersisterForKey(EntityPersister entityPersister) {
        return this.persistenceContext.getSession().getFactory().getEntityPersister(entityPersister.getRootEntityName());
    }

    protected void validateNaturalId(EntityPersister entityPersister, Object[] objectArray) {
        if (!entityPersister.hasNaturalIdentifier()) {
            throw new IllegalArgumentException("Entity did not define a natrual-id");
        }
        if (entityPersister.getNaturalIdentifierProperties().length != objectArray.length) {
            throw new IllegalArgumentException("Mismatch between expected number of natural-id values and found.");
        }
    }

    public Object[] findCachedNaturalId(EntityPersister entityPersister, Serializable serializable) {
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister = this.locatePersisterForKey(entityPersister));
        if (naturalIdResolutionCache == null) {
            return null;
        }
        CachedNaturalId cachedNaturalId = (CachedNaturalId)naturalIdResolutionCache.pkToNaturalIdMap.get(serializable);
        if (cachedNaturalId == null) {
            return null;
        }
        return cachedNaturalId.getValues();
    }

    public Serializable findCachedNaturalIdResolution(EntityPersister entityPersister, Object[] objectArray) {
        Serializable serializable;
        entityPersister = this.locatePersisterForKey(entityPersister);
        this.validateNaturalId(entityPersister, objectArray);
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister);
        CachedNaturalId cachedNaturalId = new CachedNaturalId(entityPersister, objectArray);
        if (naturalIdResolutionCache != null) {
            serializable = (Serializable)naturalIdResolutionCache.naturalIdToPkMap.get(cachedNaturalId);
            if (serializable != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Resolved natural key -> primary key resolution in session cache: " + entityPersister.getRootEntityName() + "#[" + Arrays.toString(objectArray) + "]");
                }
                return serializable;
            }
            if (naturalIdResolutionCache.containsInvalidNaturalIdReference(objectArray)) {
                return PersistenceContext.NaturalIdHelper.INVALID_NATURAL_ID_REFERENCE;
            }
        }
        if (!entityPersister.hasNaturalIdCache()) {
            return null;
        }
        NaturalIdCacheKey naturalIdCacheKey = new NaturalIdCacheKey(objectArray, entityPersister, this.session());
        NaturalIdRegionAccessStrategy naturalIdRegionAccessStrategy = entityPersister.getNaturalIdCacheAccessStrategy();
        serializable = (Serializable)naturalIdRegionAccessStrategy.get(naturalIdCacheKey, this.session().getTimestamp());
        SessionFactoryImplementor sessionFactoryImplementor = this.session().getFactory();
        if (serializable != null) {
            if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                sessionFactoryImplementor.getStatisticsImplementor().naturalIdCacheHit(naturalIdRegionAccessStrategy.getRegion().getName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Found natural key [%s] -> primary key [%s] xref in second-level cache for %s", (Object)Arrays.toString(objectArray), (Object)serializable, (Object)entityPersister.getRootEntityName());
            }
            if (naturalIdResolutionCache == null) {
                naturalIdResolutionCache = new NaturalIdResolutionCache(entityPersister);
                this.naturalIdResolutionCacheMap.put(entityPersister, naturalIdResolutionCache);
            }
            naturalIdResolutionCache.pkToNaturalIdMap.put(serializable, cachedNaturalId);
            naturalIdResolutionCache.naturalIdToPkMap.put(cachedNaturalId, serializable);
        } else if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
            sessionFactoryImplementor.getStatisticsImplementor().naturalIdCacheMiss(naturalIdRegionAccessStrategy.getRegion().getName());
        }
        return serializable;
    }

    public Collection<Serializable> getCachedPkResolutions(EntityPersister entityPersister) {
        entityPersister = this.locatePersisterForKey(entityPersister);
        Set set = null;
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister);
        if (naturalIdResolutionCache != null) {
            set = naturalIdResolutionCache.pkToNaturalIdMap.keySet();
        }
        if (set == null || set.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(set);
    }

    public void stashInvalidNaturalIdReference(EntityPersister entityPersister, Object[] objectArray) {
        NaturalIdResolutionCache naturalIdResolutionCache = this.naturalIdResolutionCacheMap.get(entityPersister = this.locatePersisterForKey(entityPersister));
        if (naturalIdResolutionCache == null) {
            throw new AssertionFailure("Expecting NaturalIdResolutionCache to exist already for entity " + entityPersister.getEntityName());
        }
        naturalIdResolutionCache.stashInvalidNaturalIdReference(objectArray);
    }

    public void unStashInvalidNaturalIdReferences() {
        for (NaturalIdResolutionCache naturalIdResolutionCache : this.naturalIdResolutionCacheMap.values()) {
            naturalIdResolutionCache.unStashInvalidNaturalIdReferences();
        }
    }

    public void clear() {
        this.naturalIdResolutionCacheMap.clear();
    }

    private static class NaturalIdResolutionCache
    implements Serializable {
        private final EntityPersister persister;
        private final Type[] naturalIdTypes;
        private Map<Serializable, CachedNaturalId> pkToNaturalIdMap = new ConcurrentHashMap<Serializable, CachedNaturalId>();
        private Map<CachedNaturalId, Serializable> naturalIdToPkMap = new ConcurrentHashMap<CachedNaturalId, Serializable>();
        private List<CachedNaturalId> invalidNaturalIdList;

        private NaturalIdResolutionCache(EntityPersister entityPersister) {
            this.persister = entityPersister;
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            this.naturalIdTypes = new Type[nArray.length];
            int n = 0;
            for (int n2 : nArray) {
                this.naturalIdTypes[n++] = entityPersister.getPropertyType(entityPersister.getPropertyNames()[n2]);
            }
        }

        public EntityPersister getPersister() {
            return this.persister;
        }

        public boolean sameAsCached(Serializable serializable, Object[] objectArray) {
            if (serializable == null) {
                return false;
            }
            CachedNaturalId cachedNaturalId = this.pkToNaturalIdMap.get(serializable);
            return cachedNaturalId != null && cachedNaturalId.isSame(objectArray);
        }

        public boolean cache(Serializable serializable, Object[] objectArray) {
            if (serializable == null) {
                return false;
            }
            CachedNaturalId cachedNaturalId = this.pkToNaturalIdMap.get(serializable);
            if (cachedNaturalId != null) {
                if (cachedNaturalId.isSame(objectArray)) {
                    return false;
                }
                this.naturalIdToPkMap.remove(cachedNaturalId);
            }
            CachedNaturalId cachedNaturalId2 = new CachedNaturalId(this.persister, objectArray);
            this.pkToNaturalIdMap.put(serializable, cachedNaturalId2);
            this.naturalIdToPkMap.put(cachedNaturalId2, serializable);
            return true;
        }

        public void stashInvalidNaturalIdReference(Object[] objectArray) {
            if (this.invalidNaturalIdList == null) {
                this.invalidNaturalIdList = new ArrayList<CachedNaturalId>();
            }
            this.invalidNaturalIdList.add(new CachedNaturalId(this.persister, objectArray));
        }

        public boolean containsInvalidNaturalIdReference(Object[] objectArray) {
            return this.invalidNaturalIdList != null && this.invalidNaturalIdList.contains(new CachedNaturalId(this.persister, objectArray));
        }

        public void unStashInvalidNaturalIdReferences() {
            if (this.invalidNaturalIdList != null) {
                this.invalidNaturalIdList.clear();
            }
        }
    }

    private static class CachedNaturalId {
        private final EntityPersister persister;
        private final Object[] values;
        private final Type[] naturalIdTypes;
        private int hashCode;

        public CachedNaturalId(EntityPersister entityPersister, Object[] objectArray) {
            this.persister = entityPersister;
            this.values = objectArray;
            int n = 1;
            n = 31 * n + entityPersister.hashCode();
            int[] nArray = entityPersister.getNaturalIdentifierProperties();
            this.naturalIdTypes = new Type[nArray.length];
            int n2 = 0;
            for (int n3 : nArray) {
                Type type;
                this.naturalIdTypes[n2] = type = entityPersister.getPropertyType(entityPersister.getPropertyNames()[n3]);
                int n4 = objectArray[n2] == null ? 0 : type.getHashCode(objectArray[n2], entityPersister.getFactory());
                n = 31 * n + n4;
                ++n2;
            }
            this.hashCode = n;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CachedNaturalId cachedNaturalId = (CachedNaturalId)object;
            return this.persister.equals(cachedNaturalId.persister) && this.isSame(cachedNaturalId.values);
        }

        private boolean isSame(Object[] objectArray) {
            for (int i = 0; i < this.naturalIdTypes.length; ++i) {
                if (this.naturalIdTypes[i].isEqual(this.values[i], objectArray[i], this.persister.getFactory())) continue;
                return false;
            }
            return true;
        }
    }
}

