/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.PropertyMapping;
import org.hibernate.type.AssociationType;

public final class JoinHelper {
    private JoinHelper() {
    }

    public static String[] getAliasedLHSColumnNames(AssociationType associationType, String string, int n, OuterJoinLoadable outerJoinLoadable, Mapping mapping) {
        return JoinHelper.getAliasedLHSColumnNames(associationType, string, n, 0, outerJoinLoadable, mapping);
    }

    public static String[] getLHSColumnNames(AssociationType associationType, int n, OuterJoinLoadable outerJoinLoadable, Mapping mapping) {
        return JoinHelper.getLHSColumnNames(associationType, n, 0, outerJoinLoadable, mapping);
    }

    public static String[] getAliasedLHSColumnNames(AssociationType associationType, String string, int n, int n2, OuterJoinLoadable outerJoinLoadable, Mapping mapping) {
        if (associationType.useLHSPrimaryKey()) {
            return StringHelper.qualify(string, outerJoinLoadable.getIdentifierColumnNames());
        }
        String string2 = associationType.getLHSPropertyName();
        if (string2 == null) {
            return ArrayHelper.slice(JoinHelper.toColumns(outerJoinLoadable, string, n), n2, associationType.getColumnSpan(mapping));
        }
        return ((PropertyMapping)((Object)outerJoinLoadable)).toColumns(string, string2);
    }

    private static String[] toColumns(OuterJoinLoadable outerJoinLoadable, String string, int n) {
        if (n >= 0) {
            return outerJoinLoadable.toColumns(string, n);
        }
        String[] stringArray = outerJoinLoadable.getIdentifierColumnNames();
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = StringHelper.qualify(string, stringArray[i]);
        }
        return stringArray2;
    }

    public static String[] getLHSColumnNames(AssociationType associationType, int n, int n2, OuterJoinLoadable outerJoinLoadable, Mapping mapping) {
        if (associationType.useLHSPrimaryKey()) {
            return outerJoinLoadable.getIdentifierColumnNames();
        }
        String string = associationType.getLHSPropertyName();
        if (string == null) {
            return ArrayHelper.slice(n < 0 ? outerJoinLoadable.getIdentifierColumnNames() : outerJoinLoadable.getSubclassPropertyColumnNames(n), n2, associationType.getColumnSpan(mapping));
        }
        return outerJoinLoadable.getPropertyColumnNames(string);
    }

    public static String getLHSTableName(AssociationType associationType, int n, OuterJoinLoadable outerJoinLoadable) {
        if (associationType.useLHSPrimaryKey() || n < 0) {
            return outerJoinLoadable.getTableName();
        }
        String string = associationType.getLHSPropertyName();
        if (string == null) {
            return outerJoinLoadable.getSubclassPropertyTableName(n);
        }
        String string2 = outerJoinLoadable.getPropertyTableName(string);
        if (string2 == null) {
            string2 = outerJoinLoadable.getSubclassPropertyTableName(n);
        }
        return string2;
    }

    public static String[] getRHSColumnNames(AssociationType associationType, SessionFactoryImplementor sessionFactoryImplementor) {
        String string = associationType.getRHSUniqueKeyPropertyName();
        Joinable joinable = associationType.getAssociatedJoinable(sessionFactoryImplementor);
        if (string == null) {
            return joinable.getKeyColumnNames();
        }
        return ((OuterJoinLoadable)joinable).getPropertyColumnNames(string);
    }
}

