/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.TransientObjectException;
import org.hibernate.bytecode.instrumentation.spi.LazyPropertyInitializer;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public final class ForeignKeys {
    private ForeignKeys() {
    }

    public static boolean isNotTransient(String string, Object object, Boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (object instanceof HibernateProxy) {
            return true;
        }
        if (sessionImplementor.getPersistenceContext().isEntryFor(object)) {
            return true;
        }
        return !ForeignKeys.isTransient(string, object, bl, sessionImplementor);
    }

    public static boolean isTransient(String string, Object object, Boolean bl, SessionImplementor sessionImplementor) throws HibernateException {
        if (object == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
            return false;
        }
        Boolean bl2 = sessionImplementor.getInterceptor().isTransient(object);
        if (bl2 != null) {
            return bl2;
        }
        EntityPersister entityPersister = sessionImplementor.getEntityPersister(string, object);
        bl2 = entityPersister.isTransient(object, sessionImplementor);
        if (bl2 != null) {
            return bl2;
        }
        if (bl != null) {
            return bl;
        }
        Object[] objectArray = sessionImplementor.getPersistenceContext().getDatabaseSnapshot(entityPersister.getIdentifier(object, sessionImplementor), entityPersister);
        return objectArray == null;
    }

    public static Serializable getEntityIdentifierIfNotUnsaved(String string, Object object, SessionImplementor sessionImplementor) throws HibernateException {
        if (object == null) {
            return null;
        }
        Serializable serializable = sessionImplementor.getContextEntityIdentifier(object);
        if (serializable == null) {
            if (ForeignKeys.isTransient(string, object, Boolean.FALSE, sessionImplementor)) {
                throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing: " + (string == null ? sessionImplementor.guessEntityName(object) : string));
            }
            serializable = sessionImplementor.getEntityPersister(string, object).getIdentifier(object, sessionImplementor);
        }
        return serializable;
    }

    public static NonNullableTransientDependencies findNonNullableTransientEntities(String string, Object object, Object[] objectArray, boolean bl, SessionImplementor sessionImplementor) {
        Nullifier nullifier = new Nullifier(object, false, bl, sessionImplementor);
        EntityPersister entityPersister = sessionImplementor.getEntityPersister(string, object);
        String[] stringArray = entityPersister.getPropertyNames();
        Type[] typeArray = entityPersister.getPropertyTypes();
        boolean[] blArray = entityPersister.getPropertyNullability();
        NonNullableTransientDependencies nonNullableTransientDependencies = new NonNullableTransientDependencies();
        for (int i = 0; i < typeArray.length; ++i) {
            ForeignKeys.collectNonNullableTransientEntities(nullifier, i, objectArray[i], stringArray[i], typeArray[i], blArray[i], sessionImplementor, nonNullableTransientDependencies);
        }
        return nonNullableTransientDependencies.isEmpty() ? null : nonNullableTransientDependencies;
    }

    private static void collectNonNullableTransientEntities(Nullifier nullifier, int n, Object object, String string, Type type, boolean bl, SessionImplementor sessionImplementor, NonNullableTransientDependencies nonNullableTransientDependencies) {
        CompositeType compositeType;
        boolean[] blArray;
        if (object == null) {
            return;
        }
        if (type.isEntityType()) {
            EntityType entityType = (EntityType)type;
            if (!bl && !entityType.isOneToOne() && nullifier.isNullifiable(entityType.getAssociatedEntityName(), object)) {
                nonNullableTransientDependencies.add(string, object);
            }
        } else if (type.isAnyType()) {
            if (!bl && nullifier.isNullifiable(null, object)) {
                nonNullableTransientDependencies.add(string, object);
            }
        } else if (type.isComponentType() && (blArray = (compositeType = (CompositeType)type).getPropertyNullability()) != null) {
            String[] stringArray = compositeType.getPropertyNames();
            Object[] objectArray = compositeType.getPropertyValues(object, sessionImplementor);
            Type[] typeArray = compositeType.getSubtypes();
            for (int i = 0; i < objectArray.length; ++i) {
                ForeignKeys.collectNonNullableTransientEntities(nullifier, i, objectArray[i], stringArray[i], typeArray[i], blArray[i], sessionImplementor, nonNullableTransientDependencies);
            }
        }
    }

    public static class Nullifier {
        private final boolean isDelete;
        private final boolean isEarlyInsert;
        private final SessionImplementor session;
        private final Object self;

        public Nullifier(Object object, boolean bl, boolean bl2, SessionImplementor sessionImplementor) {
            this.isDelete = bl;
            this.isEarlyInsert = bl2;
            this.session = sessionImplementor;
            this.self = object;
        }

        public void nullifyTransientReferences(Object[] objectArray, Type[] typeArray) throws HibernateException {
            for (int i = 0; i < typeArray.length; ++i) {
                objectArray[i] = this.nullifyTransientReferences(objectArray[i], typeArray[i]);
            }
        }

        private Object nullifyTransientReferences(Object object, Type type) throws HibernateException {
            if (object == null) {
                return null;
            }
            if (type.isEntityType()) {
                EntityType entityType = (EntityType)type;
                if (entityType.isOneToOne()) {
                    return object;
                }
                String string = entityType.getAssociatedEntityName();
                return this.isNullifiable(string, object) ? null : object;
            }
            if (type.isAnyType()) {
                return this.isNullifiable(null, object) ? null : object;
            }
            if (type.isComponentType()) {
                CompositeType compositeType = (CompositeType)type;
                Object[] objectArray = compositeType.getPropertyValues(object, this.session);
                Type[] typeArray = compositeType.getSubtypes();
                boolean bl = false;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object2 = this.nullifyTransientReferences(objectArray[i], typeArray[i]);
                    if (object2 == objectArray[i]) continue;
                    bl = true;
                    objectArray[i] = object2;
                }
                if (bl) {
                    compositeType.setPropertyValues(object, objectArray, EntityMode.POJO);
                }
                return object;
            }
            return object;
        }

        private boolean isNullifiable(String string, Object object) throws HibernateException {
            Object object2;
            if (object == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                return false;
            }
            if (object instanceof HibernateProxy) {
                object2 = ((HibernateProxy)object).getHibernateLazyInitializer();
                if (object2.getImplementation(this.session) == null) {
                    return false;
                }
                object = object2.getImplementation();
            }
            if (object == this.self) {
                return this.isEarlyInsert || this.isDelete && this.session.getFactory().getDialect().hasSelfReferentialForeignKeyBug();
            }
            object2 = this.session.getPersistenceContext().getEntry(object);
            if (object2 == null) {
                return ForeignKeys.isTransient(string, object, null, this.session);
            }
            return ((EntityEntry)object2).isNullifiable(this.isEarlyInsert, this.session);
        }
    }
}

