/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityEntryContext {
    private static final Logger log = Logger.getLogger(EntityEntryContext.class);
    private transient ManagedEntity head;
    private transient ManagedEntity tail;
    private transient int count = 0;
    private transient IdentityHashMap<Object, ManagedEntity> nonEnhancedEntityXref;
    private transient Map.Entry<Object, EntityEntry>[] reentrantSafeEntries = new Map.Entry[0];
    private transient boolean dirty = false;

    public void addEntityEntry(Object object, EntityEntry entityEntry) {
        boolean bl;
        ManagedEntity managedEntity;
        this.dirty = true;
        if (ManagedEntity.class.isInstance(object)) {
            managedEntity = (ManagedEntity)object;
            bl = managedEntity.$$_hibernate_getEntityEntry() != null;
        } else {
            ManagedEntity managedEntity2 = null;
            if (this.nonEnhancedEntityXref == null) {
                this.nonEnhancedEntityXref = new IdentityHashMap();
            } else {
                managedEntity2 = this.nonEnhancedEntityXref.get(object);
            }
            if (managedEntity2 == null) {
                managedEntity2 = new ManagedEntityImpl(object);
                this.nonEnhancedEntityXref.put(object, managedEntity2);
                bl = false;
            } else {
                bl = true;
            }
            managedEntity = managedEntity2;
        }
        managedEntity.$$_hibernate_setEntityEntry(entityEntry);
        if (bl) {
            return;
        }
        if (this.tail == null) {
            assert (this.head == null);
            this.tail = this.head = managedEntity;
            this.count = 1;
        } else {
            this.tail.$$_hibernate_setNextManagedEntity(managedEntity);
            managedEntity.$$_hibernate_setPreviousManagedEntity(this.tail);
            this.tail = managedEntity;
            ++this.count;
        }
    }

    public boolean hasEntityEntry(Object object) {
        return this.getEntityEntry(object) != null;
    }

    public EntityEntry getEntityEntry(Object object) {
        Object object2 = ManagedEntity.class.isInstance(object) ? (ManagedEntity)object : (this.nonEnhancedEntityXref == null ? null : this.nonEnhancedEntityXref.get(object));
        return object2 == null ? null : object2.$$_hibernate_getEntityEntry();
    }

    public EntityEntry removeEntityEntry(Object object) {
        this.dirty = true;
        Object object2 = ManagedEntity.class.isInstance(object) ? (ManagedEntity)object : (this.nonEnhancedEntityXref == null ? null : this.nonEnhancedEntityXref.remove(object));
        if (object2 == null) {
            return null;
        }
        ManagedEntity managedEntity = object2.$$_hibernate_getPreviousManagedEntity();
        ManagedEntity managedEntity2 = object2.$$_hibernate_getNextManagedEntity();
        object2.$$_hibernate_setPreviousManagedEntity(null);
        object2.$$_hibernate_setNextManagedEntity(null);
        --this.count;
        if (this.count == 0) {
            this.head = null;
            this.tail = null;
            assert (managedEntity == null);
            assert (managedEntity2 == null);
        } else {
            if (managedEntity == null) {
                assert (object2 == this.head);
                this.head = managedEntity2;
            } else {
                managedEntity.$$_hibernate_setNextManagedEntity(managedEntity2);
            }
            if (managedEntity2 == null) {
                assert (object2 == this.tail);
                this.tail = managedEntity;
            } else {
                managedEntity2.$$_hibernate_setPreviousManagedEntity(managedEntity);
            }
        }
        EntityEntry entityEntry = object2.$$_hibernate_getEntityEntry();
        object2.$$_hibernate_setEntityEntry(null);
        return entityEntry;
    }

    public Map.Entry<Object, EntityEntry>[] reentrantSafeEntityEntries() {
        if (this.dirty) {
            this.reentrantSafeEntries = new EntityEntryCrossRefImpl[this.count];
            int n = 0;
            for (ManagedEntity managedEntity = this.head; managedEntity != null; managedEntity = managedEntity.$$_hibernate_getNextManagedEntity()) {
                this.reentrantSafeEntries[n++] = new EntityEntryCrossRefImpl(managedEntity.$$_hibernate_getEntityInstance(), managedEntity.$$_hibernate_getEntityEntry());
            }
            this.dirty = false;
        }
        return this.reentrantSafeEntries;
    }

    public void clear() {
        this.dirty = true;
        ManagedEntity managedEntity = this.head;
        while (managedEntity != null) {
            ManagedEntity managedEntity2 = managedEntity.$$_hibernate_getNextManagedEntity();
            managedEntity.$$_hibernate_setEntityEntry(null);
            managedEntity.$$_hibernate_setPreviousManagedEntity(null);
            managedEntity.$$_hibernate_setNextManagedEntity(null);
            managedEntity = managedEntity2;
        }
        if (this.nonEnhancedEntityXref != null) {
            this.nonEnhancedEntityXref.clear();
        }
        this.head = null;
        this.tail = null;
        this.count = 0;
        this.reentrantSafeEntries = null;
    }

    public void downgradeLocks() {
        if (this.head == null) {
            return;
        }
        for (ManagedEntity managedEntity = this.head; managedEntity != null; managedEntity = managedEntity.$$_hibernate_getNextManagedEntity()) {
            managedEntity.$$_hibernate_getEntityEntry().setLockMode(LockMode.NONE);
        }
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        log.tracef("Starting serialization of [%s] EntityEntry entries", (Object)this.count);
        objectOutputStream.writeInt(this.count);
        if (this.count == 0) {
            return;
        }
        for (ManagedEntity managedEntity = this.head; managedEntity != null; managedEntity = managedEntity.$$_hibernate_getNextManagedEntity()) {
            objectOutputStream.writeBoolean(managedEntity == managedEntity.$$_hibernate_getEntityInstance());
            objectOutputStream.writeObject(managedEntity.$$_hibernate_getEntityInstance());
            managedEntity.$$_hibernate_getEntityEntry().serialize(objectOutputStream);
        }
    }

    public static EntityEntryContext deserialize(ObjectInputStream objectInputStream, StatefulPersistenceContext statefulPersistenceContext) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        log.tracef("Starting deserialization of [%s] EntityEntry entries", (Object)n);
        EntityEntryContext entityEntryContext = new EntityEntryContext();
        entityEntryContext.count = n;
        entityEntryContext.dirty = true;
        if (n == 0) {
            return entityEntryContext;
        }
        ManagedEntity managedEntity = null;
        for (int i = 0; i < n; ++i) {
            ManagedEntity managedEntity2;
            boolean bl = objectInputStream.readBoolean();
            Object object = objectInputStream.readObject();
            EntityEntry entityEntry = EntityEntry.deserialize(objectInputStream, statefulPersistenceContext);
            if (bl) {
                managedEntity2 = (ManagedEntity)object;
            } else {
                managedEntity2 = new ManagedEntityImpl(object);
                if (entityEntryContext.nonEnhancedEntityXref == null) {
                    entityEntryContext.nonEnhancedEntityXref = new IdentityHashMap();
                }
                entityEntryContext.nonEnhancedEntityXref.put(object, managedEntity2);
            }
            managedEntity2.$$_hibernate_setEntityEntry(entityEntry);
            if (managedEntity == null) {
                entityEntryContext.head = managedEntity2;
            } else {
                managedEntity.$$_hibernate_setNextManagedEntity(managedEntity2);
                managedEntity2.$$_hibernate_setPreviousManagedEntity(managedEntity);
            }
            managedEntity = managedEntity2;
        }
        entityEntryContext.tail = managedEntity;
        return entityEntryContext;
    }

    public int getNumberOfManagedEntities() {
        return this.count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EntityEntryCrossRef
    extends Map.Entry<Object, EntityEntry> {
        public Object getEntity();

        public EntityEntry getEntityEntry();
    }

    private static class EntityEntryCrossRefImpl
    implements EntityEntryCrossRef {
        private final Object entity;
        private EntityEntry entityEntry;

        private EntityEntryCrossRefImpl(Object object, EntityEntry entityEntry) {
            this.entity = object;
            this.entityEntry = entityEntry;
        }

        public Object getEntity() {
            return this.entity;
        }

        public EntityEntry getEntityEntry() {
            return this.entityEntry;
        }

        public Object getKey() {
            return this.getEntity();
        }

        public EntityEntry getValue() {
            return this.getEntityEntry();
        }

        public EntityEntry setValue(EntityEntry entityEntry) {
            EntityEntry entityEntry2 = this.entityEntry;
            this.entityEntry = entityEntry;
            return entityEntry2;
        }
    }

    private static class ManagedEntityImpl
    implements ManagedEntity {
        private final Object entityInstance;
        private EntityEntry entityEntry;
        private ManagedEntity previous;
        private ManagedEntity next;

        public ManagedEntityImpl(Object object) {
            this.entityInstance = object;
        }

        public Object $$_hibernate_getEntityInstance() {
            return this.entityInstance;
        }

        public EntityEntry $$_hibernate_getEntityEntry() {
            return this.entityEntry;
        }

        public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
            this.entityEntry = entityEntry;
        }

        public ManagedEntity $$_hibernate_getNextManagedEntity() {
            return this.next;
        }

        public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
            this.next = managedEntity;
        }

        public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
            return this.previous;
        }

        public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
            this.previous = managedEntity;
        }
    }
}

