/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.jboss.logging.Logger;

public final class Collections {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Collections.class.getName());

    private Collections() {
    }

    public static void processUnreachableCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) {
        if (persistentCollection.getOwner() == null) {
            Collections.processNeverReferencedCollection(persistentCollection, sessionImplementor);
        } else {
            Collections.processDereferencedCollection(persistentCollection, sessionImplementor);
        }
    }

    private static void processDereferencedCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) {
        boolean bl;
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(persistentCollection);
        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
        if (collectionPersister != null && LOG.isDebugEnabled()) {
            LOG.debugf("Collection dereferenced: %s", (Object)MessageHelper.collectionInfoString(collectionPersister, persistentCollection, collectionEntry.getLoadedKey(), sessionImplementor));
        }
        boolean bl2 = bl = collectionPersister != null && collectionPersister.hasOrphanDelete();
        if (bl) {
            Object object;
            Serializable serializable;
            Serializable serializable2 = collectionPersister.getOwnerEntityPersister().getIdentifier(persistentCollection.getOwner(), sessionImplementor);
            if (serializable2 == null) {
                if (sessionImplementor.getFactory().getSettings().isIdentifierRollbackEnabled() && (serializable = persistenceContext.getEntry(persistentCollection.getOwner())) != null) {
                    serializable2 = ((EntityEntry)serializable).getId();
                }
                if (serializable2 == null) {
                    throw new AssertionFailure("Unable to determine collection owner identifier for orphan-delete processing");
                }
            }
            if ((object = persistenceContext.getEntity((EntityKey)(serializable = sessionImplementor.generateEntityKey(serializable2, collectionPersister.getOwnerEntityPersister())))) == null) {
                throw new AssertionFailure("collection owner not associated with session: " + collectionPersister.getRole());
            }
            EntityEntry entityEntry = persistenceContext.getEntry(object);
            if (entityEntry != null && entityEntry.getStatus() != Status.DELETED && entityEntry.getStatus() != Status.GONE) {
                throw new HibernateException("A collection with cascade=\"all-delete-orphan\" was no longer referenced by the owning entity instance: " + collectionPersister.getRole());
            }
        }
        collectionEntry.setCurrentPersister(null);
        collectionEntry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionImplementor.getFactory());
    }

    private static void processNeverReferencedCollection(PersistentCollection persistentCollection, SessionImplementor sessionImplementor) throws HibernateException {
        PersistenceContext persistenceContext = sessionImplementor.getPersistenceContext();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(persistentCollection);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Found collection with unloaded owner: %s", (Object)MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), persistentCollection, collectionEntry.getLoadedKey(), sessionImplementor));
        }
        collectionEntry.setCurrentPersister(collectionEntry.getLoadedPersister());
        collectionEntry.setCurrentKey(collectionEntry.getLoadedKey());
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionImplementor.getFactory());
    }

    public static void processReachableCollection(PersistentCollection persistentCollection, CollectionType collectionType, Object object, SessionImplementor sessionImplementor) {
        persistentCollection.setOwner(object);
        CollectionEntry collectionEntry = sessionImplementor.getPersistenceContext().getCollectionEntry(persistentCollection);
        if (collectionEntry == null) {
            throw new HibernateException("Found two representations of same collection: " + collectionType.getRole());
        }
        if (collectionEntry.isReached()) {
            throw new HibernateException("Found shared references to a collection: " + collectionType.getRole());
        }
        collectionEntry.setReached(true);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        CollectionPersister collectionPersister = sessionFactoryImplementor.getCollectionPersister(collectionType.getRole());
        collectionEntry.setCurrentPersister(collectionPersister);
        collectionEntry.setCurrentKey(collectionType.getKeyOfOwner(object, sessionImplementor));
        if (LOG.isDebugEnabled()) {
            if (persistentCollection.wasInitialized()) {
                LOG.debugf("Collection found: %s, was: %s (initialized)", (Object)MessageHelper.collectionInfoString(collectionPersister, persistentCollection, collectionEntry.getCurrentKey(), sessionImplementor), (Object)MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), persistentCollection, collectionEntry.getLoadedKey(), sessionImplementor));
            } else {
                LOG.debugf("Collection found: %s, was: %s (uninitialized)", (Object)MessageHelper.collectionInfoString(collectionPersister, persistentCollection, collectionEntry.getCurrentKey(), sessionImplementor), (Object)MessageHelper.collectionInfoString(collectionEntry.getLoadedPersister(), persistentCollection, collectionEntry.getLoadedKey(), sessionImplementor));
            }
        }
        Collections.prepareCollectionForUpdate(persistentCollection, collectionEntry, sessionFactoryImplementor);
    }

    private static void prepareCollectionForUpdate(PersistentCollection persistentCollection, CollectionEntry collectionEntry, SessionFactoryImplementor sessionFactoryImplementor) {
        if (collectionEntry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        collectionEntry.setProcessed(true);
        CollectionPersister collectionPersister = collectionEntry.getLoadedPersister();
        CollectionPersister collectionPersister2 = collectionEntry.getCurrentPersister();
        if (collectionPersister != null || collectionPersister2 != null) {
            boolean bl;
            boolean bl2 = bl = collectionPersister != collectionPersister2 || !collectionPersister2.getKeyType().isEqual(collectionEntry.getLoadedKey(), collectionEntry.getCurrentKey(), sessionFactoryImplementor);
            if (bl) {
                boolean bl3;
                boolean bl4 = bl3 = collectionPersister != null && collectionPersister2 != null && collectionPersister.hasOrphanDelete();
                if (bl3) {
                    throw new HibernateException("Don't change the reference to a collection with cascade=\"all-delete-orphan\": " + collectionPersister.getRole());
                }
                if (collectionPersister2 != null) {
                    collectionEntry.setDorecreate(true);
                }
                if (collectionPersister != null) {
                    collectionEntry.setDoremove(true);
                    if (collectionEntry.isDorecreate()) {
                        LOG.trace("Forcing collection initialization");
                        persistentCollection.forceInitialization();
                    }
                }
            } else if (persistentCollection.isDirty()) {
                collectionEntry.setDoupdate(true);
            }
        }
    }
}

