/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.hibernate.HibernateException;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public final class Cascade {
    public static final int AFTER_INSERT_BEFORE_DELETE = 1;
    public static final int BEFORE_INSERT_AFTER_DELETE = 2;
    public static final int AFTER_INSERT_BEFORE_DELETE_VIA_COLLECTION = 3;
    public static final int AFTER_UPDATE = 0;
    public static final int BEFORE_FLUSH = 0;
    public static final int AFTER_EVICT = 0;
    public static final int BEFORE_REFRESH = 0;
    public static final int AFTER_LOCK = 0;
    public static final int BEFORE_MERGE = 0;
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, Cascade.class.getName());
    private int cascadeTo;
    private EventSource eventSource;
    private CascadingAction action;
    private Stack componentPathStack = new Stack();

    public Cascade(CascadingAction cascadingAction, int n, EventSource eventSource) {
        this.cascadeTo = n;
        this.eventSource = eventSource;
        this.action = cascadingAction;
    }

    private SessionFactoryImplementor getFactory() {
        return this.eventSource.getFactory();
    }

    public void cascade(EntityPersister entityPersister, Object object) throws HibernateException {
        this.cascade(entityPersister, object, null);
    }

    public void cascade(EntityPersister entityPersister, Object object, Object object2) throws HibernateException {
        if (entityPersister.hasCascades() || this.action.requiresNoCascadeChecking()) {
            boolean bl = LOG.isTraceEnabled();
            if (bl) {
                LOG.tracev("Processing cascade {0} for: {1}", (Object)this.action, (Object)entityPersister.getEntityName());
            }
            Type[] typeArray = entityPersister.getPropertyTypes();
            CascadeStyle[] cascadeStyleArray = entityPersister.getPropertyCascadeStyles();
            boolean bl2 = entityPersister.hasUninitializedLazyProperties(object);
            for (int i = 0; i < typeArray.length; ++i) {
                CascadeStyle cascadeStyle = cascadeStyleArray[i];
                String string = entityPersister.getPropertyNames()[i];
                if (bl2 && entityPersister.getPropertyLaziness()[i] && !this.action.performOnLazyProperty()) continue;
                if (cascadeStyle.doCascade(this.action)) {
                    this.cascadeProperty(object, entityPersister.getPropertyValue(object, i), typeArray[i], cascadeStyle, string, object2, false);
                    continue;
                }
                if (!this.action.requiresNoCascadeChecking()) continue;
                this.action.noCascade(this.eventSource, entityPersister.getPropertyValue(object, i), object, entityPersister, i);
            }
            if (bl) {
                LOG.tracev("Done processing cascade {0} for: {1}", (Object)this.action, (Object)entityPersister.getEntityName());
            }
        }
    }

    private void cascadeProperty(Object object, Object object2, Type type, CascadeStyle cascadeStyle, String string, Object object3, boolean bl) throws HibernateException {
        EntityEntry entityEntry;
        Object object4;
        EntityEntry entityEntry2;
        if (object2 != null) {
            if (type.isAssociationType()) {
                AssociationType associationType = (AssociationType)type;
                if (this.cascadeAssociationNow(associationType)) {
                    this.cascadeAssociation(object, object2, type, cascadeStyle, object3, bl);
                }
            } else if (type.isComponentType()) {
                this.cascadeComponent(object, object2, (CompositeType)type, string, object3);
            }
        } else if (this.isLogicalOneToOne(type) && cascadeStyle.hasOrphanDelete() && this.action.deleteOrphans() && (entityEntry2 = this.eventSource.getPersistenceContext().getEntry(object)) != null && entityEntry2.getStatus() != Status.SAVING && (object4 = this.componentPathStack.isEmpty() ? entityEntry2.getLoadedValue(string) : null) != null && (entityEntry = this.eventSource.getPersistenceContext().getEntry(object4)) != null) {
            String string2 = entityEntry.getPersister().getEntityName();
            if (LOG.isTraceEnabled()) {
                Serializable serializable = entityEntry.getPersister().getIdentifier(object4, this.eventSource);
                String string3 = MessageHelper.infoString(string2, serializable);
                LOG.tracev("Deleting orphaned entity instance: {0}", (Object)string3);
            }
            this.eventSource.delete(string2, object4, false, new HashSet());
        }
    }

    private boolean isLogicalOneToOne(Type type) {
        return type.isEntityType() && ((EntityType)type).isLogicalOneToOne();
    }

    private boolean cascadeAssociationNow(AssociationType associationType) {
        return associationType.getForeignKeyDirection().cascadeNow(this.cascadeTo);
    }

    private void cascadeComponent(Object object, Object object2, CompositeType compositeType, String string, Object object3) {
        this.componentPathStack.push(string);
        Object[] objectArray = compositeType.getPropertyValues(object2, this.eventSource);
        Type[] typeArray = compositeType.getSubtypes();
        for (int i = 0; i < typeArray.length; ++i) {
            CascadeStyle cascadeStyle = compositeType.getCascadeStyle(i);
            String string2 = compositeType.getPropertyNames()[i];
            if (!cascadeStyle.doCascade(this.action)) continue;
            this.cascadeProperty(object, objectArray[i], typeArray[i], cascadeStyle, string2, object3, false);
        }
        this.componentPathStack.pop();
    }

    private void cascadeAssociation(Object object, Object object2, Type type, CascadeStyle cascadeStyle, Object object3, boolean bl) {
        if (type.isEntityType() || type.isAnyType()) {
            this.cascadeToOne(object, object2, type, cascadeStyle, object3, bl);
        } else if (type.isCollectionType()) {
            this.cascadeCollection(object, object2, cascadeStyle, object3, (CollectionType)type);
        }
    }

    private void cascadeCollection(Object object, Object object2, CascadeStyle cascadeStyle, Object object3, CollectionType collectionType) {
        CollectionPersister collectionPersister = this.eventSource.getFactory().getCollectionPersister(collectionType.getRole());
        Type type = collectionPersister.getElementType();
        int n = this.cascadeTo;
        if (this.cascadeTo == 1) {
            this.cascadeTo = 3;
        }
        if (type.isEntityType() || type.isAnyType() || type.isComponentType()) {
            this.cascadeCollectionElements(object, object2, collectionType, cascadeStyle, type, object3, collectionPersister.isCascadeDeleteEnabled());
        }
        this.cascadeTo = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeToOne(Object object, Object object2, Type type, CascadeStyle cascadeStyle, Object object3, boolean bl) {
        String string;
        String string2 = string = type.isEntityType() ? ((EntityType)type).getAssociatedEntityName() : null;
        if (cascadeStyle.reallyDoCascade(this.action)) {
            this.eventSource.getPersistenceContext().addChildParent(object2, object);
            try {
                this.action.cascade(this.eventSource, object2, string, object3, bl);
            }
            finally {
                this.eventSource.getPersistenceContext().removeChildParent(object2);
            }
        }
    }

    private void cascadeCollectionElements(Object object, Object object2, CollectionType collectionType, CascadeStyle cascadeStyle, Type type, Object object3, boolean bl) throws HibernateException {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = cascadeStyle.reallyDoCascade(this.action) && object2 != CollectionType.UNFETCHED_COLLECTION;
        if (bl3) {
            bl2 = LOG.isTraceEnabled();
            if (bl2) {
                LOG.tracev("Cascade {0} for collection: {1}", (Object)this.action, (Object)collectionType.getRole());
            }
            Iterator iterator = this.action.getCascadableChildrenIterator(this.eventSource, collectionType, object2);
            while (iterator.hasNext()) {
                this.cascadeProperty(object, iterator.next(), type, cascadeStyle, null, object3, bl);
            }
            if (bl2) {
                LOG.tracev("Done cascade {0} for collection: {1}", (Object)this.action, (Object)collectionType.getRole());
            }
        }
        boolean bl5 = bl2 = cascadeStyle.hasOrphanDelete() && this.action.deleteOrphans() && type.isEntityType() && object2 instanceof PersistentCollection;
        if (bl2) {
            boolean bl6 = LOG.isTraceEnabled();
            if (bl6) {
                LOG.tracev("Deleting orphans for collection: {0}", (Object)collectionType.getRole());
            }
            String string = collectionType.getAssociatedEntityName(this.eventSource.getFactory());
            this.deleteOrphans(string, (PersistentCollection)object2);
            if (bl6) {
                LOG.tracev("Done deleting orphans for collection: {0}", (Object)collectionType.getRole());
            }
        }
    }

    private void deleteOrphans(String string, PersistentCollection persistentCollection) throws HibernateException {
        Object object;
        Collection collection = persistentCollection.wasInitialized() ? ((object = this.eventSource.getPersistenceContext().getCollectionEntry(persistentCollection)) == null ? Collections.EMPTY_LIST : ((CollectionEntry)object).getOrphans(string, persistentCollection)) : persistentCollection.getQueuedOrphans(string);
        for (Object e : collection) {
            if (e == null) continue;
            LOG.tracev("Deleting orphaned entity instance: {0}", (Object)string);
            this.eventSource.delete(string, e, false, new HashSet());
        }
    }
}

