/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.relational.UniqueKey;

public class DefaultUniqueDelegate
implements UniqueDelegate {
    protected final Dialect dialect;

    public DefaultUniqueDelegate(Dialect dialect) {
        this.dialect = dialect;
    }

    public String applyUniqueToColumn(Column column) {
        return "";
    }

    public String applyUniqueToColumn(org.hibernate.metamodel.relational.Column column) {
        return "";
    }

    public String applyUniquesToTable(Table table) {
        return "";
    }

    public String applyUniquesToTable(org.hibernate.metamodel.relational.Table table) {
        return "";
    }

    public String applyUniquesOnAlter(org.hibernate.mapping.UniqueKey uniqueKey, String string, String string2) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect, string, string2) + " add constraint " + uniqueKey.getName() + this.uniqueConstraintSql(uniqueKey);
    }

    public String applyUniquesOnAlter(UniqueKey uniqueKey) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect) + " add constraint " + uniqueKey.getName() + this.uniqueConstraintSql(uniqueKey);
    }

    public String dropUniquesOnAlter(org.hibernate.mapping.UniqueKey uniqueKey, String string, String string2) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect, string, string2) + " drop constraint " + this.dialect.quote(uniqueKey.getName());
    }

    public String dropUniquesOnAlter(UniqueKey uniqueKey) {
        return "alter table " + uniqueKey.getTable().getQualifiedName(this.dialect) + " drop constraint " + this.dialect.quote(uniqueKey.getName());
    }

    public String uniqueConstraintSql(org.hibernate.mapping.UniqueKey uniqueKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" unique (");
        Iterator iterator = uniqueKey.getColumnIterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            stringBuilder.append(column.getQuotedName(this.dialect));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(')').toString();
    }

    public String uniqueConstraintSql(UniqueKey uniqueKey) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" unique (");
        Iterator<org.hibernate.metamodel.relational.Column> iterator = uniqueKey.getColumns().iterator();
        while (iterator.hasNext()) {
            Column column = (Column)((Object)iterator.next());
            stringBuilder.append(column.getQuotedName(this.dialect));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(')').toString();
    }
}

