/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.unique;

import java.util.Iterator;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.unique.DefaultUniqueDelegate;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.UniqueKey;

public class DB2UniqueDelegate
extends DefaultUniqueDelegate {
    public DB2UniqueDelegate(Dialect dialect) {
        super(dialect);
    }

    public String applyUniquesOnAlter(UniqueKey uniqueKey, String string, String string2) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlCreateIndexString(this.dialect, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.columnIterator(), true, string, string2);
        }
        return super.applyUniquesOnAlter(uniqueKey, string, string2);
    }

    public String applyUniquesOnAlter(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        if (this.hasNullable(uniqueKey)) {
            return org.hibernate.metamodel.relational.Index.buildSqlCreateIndexString(this.dialect, uniqueKey.getName(), uniqueKey.getTable(), uniqueKey.getColumns(), true);
        }
        return super.applyUniquesOnAlter(uniqueKey);
    }

    public String dropUniquesOnAlter(UniqueKey uniqueKey, String string, String string2) {
        if (this.hasNullable(uniqueKey)) {
            return Index.buildSqlDropIndexString(this.dialect, uniqueKey.getTable(), uniqueKey.getName(), string, string2);
        }
        return super.dropUniquesOnAlter(uniqueKey, string, string2);
    }

    public String dropUniquesOnAlter(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        if (this.hasNullable(uniqueKey)) {
            return org.hibernate.metamodel.relational.Index.buildSqlDropIndexString(this.dialect, uniqueKey.getTable(), uniqueKey.getName());
        }
        return super.dropUniquesOnAlter(uniqueKey);
    }

    private boolean hasNullable(UniqueKey uniqueKey) {
        Iterator iterator = uniqueKey.getColumnIterator();
        while (iterator.hasNext()) {
            if (!((Column)iterator.next()).isNullable()) continue;
            return true;
        }
        return false;
    }

    private boolean hasNullable(org.hibernate.metamodel.relational.UniqueKey uniqueKey) {
        Iterator<org.hibernate.metamodel.relational.Column> iterator = uniqueKey.getColumns().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isNullable()) continue;
            return true;
        }
        return false;
    }
}

