/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.internal.util.StringHelper;

public class SQLServer2005LimitHandler
extends AbstractLimitHandler {
    private static final String SELECT = "select";
    private static final String SELECT_WITH_SPACE = "select ";
    private static final String FROM = "from";
    private static final String DISTINCT = "distinct";
    private static final String ORDER_BY = "order by";
    private static final Pattern ALIAS_PATTERN = Pattern.compile("(?i)\\sas\\s(.)+$");
    private boolean topAdded = false;
    private boolean hasOffset = true;

    public SQLServer2005LimitHandler(String string, RowSelection rowSelection) {
        super(string, rowSelection);
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return true;
    }

    public boolean supportsVariableLimit() {
        return true;
    }

    public int convertToFirstRowValue(int n) {
        return n + 1;
    }

    public String getProcessedSql() {
        StringBuilder stringBuilder = new StringBuilder(this.sql);
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (LimitHelper.hasFirstRow(this.selection)) {
            String string = this.fillAliasInSelectClause(stringBuilder);
            int n = SQLServer2005LimitHandler.shallowIndexOfWord(stringBuilder, ORDER_BY, 0);
            if (n > 0) {
                this.addTopExpression(stringBuilder);
            }
            this.encloseWithOuterQuery(stringBuilder);
            stringBuilder.insert(0, "WITH query AS (").append(") SELECT ").append(string).append(" FROM query ");
            stringBuilder.append("WHERE __hibernate_row_nr__ >= ? AND __hibernate_row_nr__ < ?");
        } else {
            this.hasOffset = false;
            this.addTopExpression(stringBuilder);
        }
        return stringBuilder.toString();
    }

    public int bindLimitParametersAtStartOfQuery(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.topAdded) {
            preparedStatement.setInt(n, this.getMaxOrLimit() - 1);
            return 1;
        }
        return 0;
    }

    public int bindLimitParametersAtEndOfQuery(PreparedStatement preparedStatement, int n) throws SQLException {
        return this.hasOffset ? super.bindLimitParametersAtEndOfQuery(preparedStatement, n) : 0;
    }

    protected String fillAliasInSelectClause(StringBuilder stringBuilder) {
        String string;
        String string2;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n = SQLServer2005LimitHandler.shallowIndexOf(stringBuilder, SELECT_WITH_SPACE, 0);
        int n2 = SQLServer2005LimitHandler.shallowIndexOfWord(stringBuilder, FROM, n);
        int n3 = n;
        int n4 = n;
        int n5 = 0;
        boolean bl = false;
        while (n3 != -1) {
            n4 = n3;
            if ((n3 = SQLServer2005LimitHandler.shallowIndexOf(stringBuilder, ",", n3)) > n2) break;
            if (n3 == -1) continue;
            string2 = stringBuilder.substring(n4, n3);
            if (this.selectsMultipleColumns(string2)) {
                bl = true;
            } else {
                string = this.getAlias(string2);
                if (string == null) {
                    string = StringHelper.generateAlias("page", n5);
                    stringBuilder.insert(n3, " as " + string);
                    int n6 = (" as " + string).length();
                    ++n5;
                    n3 += n6;
                    n2 += n6;
                }
                linkedList.add(string);
            }
            ++n3;
        }
        if (this.selectsMultipleColumns(string2 = stringBuilder.substring(n4, n2 = SQLServer2005LimitHandler.shallowIndexOfWord(stringBuilder, FROM, n)))) {
            bl = true;
        } else {
            string = this.getAlias(string2);
            if (string == null) {
                string = StringHelper.generateAlias("page", n5);
                stringBuilder.insert(n2 - 1, " as " + string);
            }
            linkedList.add(string);
        }
        return bl ? "*" : StringHelper.join(", ", linkedList.iterator());
    }

    private boolean selectsMultipleColumns(String string) {
        String string2 = string.trim().replaceFirst("(?i)(.)*\\s", "");
        return "*".equals(string2) || string2.endsWith(".*");
    }

    private String getAlias(String string) {
        Matcher matcher = ALIAS_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(0).replaceFirst("(?i)(.)*\\sas\\s", "").trim();
        }
        return null;
    }

    protected void encloseWithOuterQuery(StringBuilder stringBuilder) {
        stringBuilder.insert(0, "SELECT inner_query.*, ROW_NUMBER() OVER (ORDER BY CURRENT_TIMESTAMP) as __hibernate_row_nr__ FROM ( ");
        stringBuilder.append(" ) inner_query ");
    }

    protected void addTopExpression(StringBuilder stringBuilder) {
        int n = SQLServer2005LimitHandler.shallowIndexOfWord(stringBuilder, DISTINCT, 0);
        if (n > 0) {
            stringBuilder.insert(n + DISTINCT.length(), " TOP(?)");
        } else {
            int n2 = SQLServer2005LimitHandler.shallowIndexOf(stringBuilder, SELECT_WITH_SPACE, 0);
            stringBuilder.insert(n2 + SELECT.length(), " TOP(?)");
        }
        this.topAdded = true;
    }

    private static int shallowIndexOfWord(StringBuilder stringBuilder, String string, int n) {
        int n2 = SQLServer2005LimitHandler.shallowIndexOf(stringBuilder, ' ' + string + ' ', n);
        return n2 != -1 ? n2 + 1 : -1;
    }

    private static int shallowIndexOf(StringBuilder stringBuilder, String string, int n) {
        String string2 = stringBuilder.toString().toLowerCase();
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = -1;
        int n5 = 0;
        int n6 = n;
        do {
            if ((n4 = string2.indexOf(string, n6)) == -1) continue;
            for (int i = n6; i < n4; ++i) {
                char c = stringBuilder.charAt(i);
                if (c == '(') {
                    ++n5;
                    continue;
                }
                if (c != ')') continue;
                --n5;
            }
            n6 = n4 + n3;
        } while (n6 < n2 && n5 != 0 && n4 != -1);
        return n5 == 0 ? n4 : -1;
    }
}

