/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitHelper;
import org.hibernate.engine.spi.RowSelection;

public abstract class AbstractLimitHandler
implements LimitHandler {
    protected final String sql;
    protected final RowSelection selection;

    public AbstractLimitHandler(String string, RowSelection rowSelection) {
        this.sql = string;
        this.selection = rowSelection;
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return false;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public boolean forceLimitUsage() {
        return false;
    }

    public int convertToFirstRowValue(int n) {
        return n;
    }

    public String getProcessedSql() {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public int bindLimitParametersAtStartOfQuery(PreparedStatement preparedStatement, int n) throws SQLException {
        return this.bindLimitParametersFirst() ? this.bindLimitParameters(preparedStatement, n) : 0;
    }

    public int bindLimitParametersAtEndOfQuery(PreparedStatement preparedStatement, int n) throws SQLException {
        return !this.bindLimitParametersFirst() ? this.bindLimitParameters(preparedStatement, n) : 0;
    }

    public void setMaxRows(PreparedStatement preparedStatement) throws SQLException {
    }

    protected int bindLimitParameters(PreparedStatement preparedStatement, int n) throws SQLException {
        if (!this.supportsVariableLimit() || !LimitHelper.hasMaxRows(this.selection)) {
            return 0;
        }
        int n2 = this.convertToFirstRowValue(LimitHelper.getFirstRow(this.selection));
        int n3 = this.getMaxOrLimit();
        boolean bl = this.supportsLimitOffset() && (n2 > 0 || this.forceLimitUsage());
        boolean bl2 = this.bindLimitParametersInReverseOrder();
        if (bl) {
            preparedStatement.setInt(n + (bl2 ? 1 : 0), n2);
        }
        preparedStatement.setInt(n + (bl2 || !bl ? 0 : 1), n3);
        return bl ? 2 : 1;
    }

    protected int getMaxOrLimit() {
        int n = this.convertToFirstRowValue(LimitHelper.getFirstRow(this.selection));
        int n2 = this.selection.getMaxRows();
        return this.useMaxForLimit() ? n2 + n : n2;
    }
}

