/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.Update;
import org.jboss.logging.Logger;

public class PessimisticReadUpdateLockingStrategy
implements LockingStrategy {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, PessimisticReadUpdateLockingStrategy.class.getName());
    private final Lockable lockable;
    private final LockMode lockMode;
    private final String sql;

    public PessimisticReadUpdateLockingStrategy(Lockable lockable, LockMode lockMode) {
        this.lockable = lockable;
        this.lockMode = lockMode;
        if (lockMode.lessThan(LockMode.PESSIMISTIC_READ)) {
            throw new HibernateException("[" + (Object)((Object)lockMode) + "] not valid for update statement");
        }
        if (!lockable.isVersioned()) {
            LOG.writeLocksNotSupported(lockable.getEntityName());
            this.sql = null;
        } else {
            this.sql = this.generateLockString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable serializable, Object object, Object object2, int n, SessionImplementor sessionImplementor) {
        if (!this.lockable.isVersioned()) {
            throw new HibernateException("write locks via update not supported for non-versioned entities [" + this.lockable.getEntityName() + "]");
        }
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        try {
            try {
                PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.sql);
                try {
                    int n2;
                    this.lockable.getVersionType().nullSafeSet(preparedStatement, object, 1, sessionImplementor);
                    int n3 = 2;
                    this.lockable.getIdentifierType().nullSafeSet(preparedStatement, serializable, n3, sessionImplementor);
                    n3 += this.lockable.getIdentifierType().getColumnSpan(sessionFactoryImplementor);
                    if (this.lockable.isVersioned()) {
                        this.lockable.getVersionType().nullSafeSet(preparedStatement, object, n3, sessionImplementor);
                    }
                    if ((n2 = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement)) < 0) {
                        if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                            sessionFactoryImplementor.getStatisticsImplementor().optimisticFailure(this.lockable.getEntityName());
                        }
                        throw new StaleObjectStateException(this.lockable.getEntityName(), serializable);
                    }
                }
                finally {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not lock: " + MessageHelper.infoString((EntityPersister)this.lockable, serializable, sessionImplementor.getFactory()), this.sql);
            }
        }
        catch (JDBCException jDBCException) {
            throw new PessimisticEntityLockException(object2, "could not obtain pessimistic lock", jDBCException);
        }
    }

    protected String generateLockString() {
        SessionFactoryImplementor sessionFactoryImplementor = this.lockable.getFactory();
        Update update = new Update(sessionFactoryImplementor.getDialect());
        update.setTableName(this.lockable.getRootTableName());
        update.addPrimaryKeyColumns(this.lockable.getRootTableIdentifierColumnNames());
        update.setVersionColumnName(this.lockable.getVersionColumnName());
        update.addColumn(this.lockable.getVersionColumnName());
        if (sessionFactoryImplementor.getSettings().isCommentsEnabled()) {
            update.setComment((Object)((Object)this.lockMode) + " lock " + this.lockable.getEntityName());
        }
        return update.toStatementString();
    }

    protected LockMode getLockMode() {
        return this.lockMode;
    }
}

