/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.AbstractSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.sql.SimpleSelect;

public class PessimisticReadSelectLockingStrategy
extends AbstractSelectLockingStrategy {
    public PessimisticReadSelectLockingStrategy(Lockable lockable, LockMode lockMode) {
        super(lockable, lockMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Serializable serializable, Object object, Object object2, int n, SessionImplementor sessionImplementor) {
        String string = this.determineSql(n);
        SessionFactoryImplementor sessionFactoryImplementor = sessionImplementor.getFactory();
        try {
            try {
                PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(string);
                try {
                    this.getLockable().getIdentifierType().nullSafeSet(preparedStatement, serializable, 1, sessionImplementor);
                    if (this.getLockable().isVersioned()) {
                        this.getLockable().getVersionType().nullSafeSet(preparedStatement, object, this.getLockable().getIdentifierType().getColumnSpan(sessionFactoryImplementor) + 1, sessionImplementor);
                    }
                    ResultSet resultSet = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().extract(preparedStatement);
                    try {
                        if (!resultSet.next()) {
                            if (sessionFactoryImplementor.getStatistics().isStatisticsEnabled()) {
                                sessionFactoryImplementor.getStatisticsImplementor().optimisticFailure(this.getLockable().getEntityName());
                            }
                            throw new StaleObjectStateException(this.getLockable().getEntityName(), serializable);
                        }
                    }
                    finally {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(resultSet);
                    }
                }
                finally {
                    sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release(preparedStatement);
                }
            }
            catch (SQLException sQLException) {
                throw sessionImplementor.getFactory().getSQLExceptionHelper().convert(sQLException, "could not lock: " + MessageHelper.infoString((EntityPersister)this.getLockable(), serializable, sessionImplementor.getFactory()), string);
            }
        }
        catch (JDBCException jDBCException) {
            throw new PessimisticEntityLockException(object2, "could not obtain pessimistic lock", jDBCException);
        }
    }

    protected String generateLockString(int n) {
        SessionFactoryImplementor sessionFactoryImplementor = this.getLockable().getFactory();
        LockOptions lockOptions = new LockOptions(this.getLockMode());
        lockOptions.setTimeOut(n);
        SimpleSelect simpleSelect = new SimpleSelect(sessionFactoryImplementor.getDialect()).setLockOptions(lockOptions).setTableName(this.getLockable().getRootTableName()).addColumn(this.getLockable().getRootTableIdentifierColumnNames()[0]).addCondition(this.getLockable().getRootTableIdentifierColumnNames(), "=?");
        if (this.getLockable().isVersioned()) {
            simpleSelect.addCondition(this.getLockable().getVersionColumnName(), "=?");
        }
        if (sessionFactoryImplementor.getSettings().isCommentsEnabled()) {
            simpleSelect.setComment((Object)((Object)this.getLockMode()) + " lock " + this.getLockable().getEntityName());
        }
        return simpleSelect.toStatementString();
    }
}

