/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class StandardSQLFunction
implements SQLFunction {
    private final String name;
    private final Type registeredType;

    public StandardSQLFunction(String string) {
        this(string, null);
    }

    public StandardSQLFunction(String string, Type type) {
        this.name = string;
        this.registeredType = type;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.registeredType;
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Type getReturnType(Type type, Mapping mapping) {
        return this.registeredType == null ? type : this.registeredType;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append('(');
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.append(')').toString();
    }

    public String toString() {
        return this.name;
    }
}

