/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnsiSqlAggregationFunctions {
    public static void primeFunctionMap(Map<String, SQLFunction> map) {
        map.put(AvgFunction.INSTANCE.getName(), AvgFunction.INSTANCE);
        map.put(CountFunction.INSTANCE.getName(), CountFunction.INSTANCE);
        map.put(MaxFunction.INSTANCE.getName(), MaxFunction.INSTANCE);
        map.put(MinFunction.INSTANCE.getName(), MinFunction.INSTANCE);
        map.put(SumFunction.INSTANCE.getName(), SumFunction.INSTANCE);
    }

    public static class SumFunction
    extends StandardSQLFunction {
        public static final SumFunction INSTANCE = new SumFunction();

        public SumFunction() {
            super("sum");
        }

        protected final int determineJdbcTypeCode(Type type, Mapping mapping) throws QueryException {
            try {
                int[] nArray = type.sqlTypes(mapping);
                if (nArray.length != 1) {
                    throw new QueryException("multiple-column type in sum()");
                }
                return nArray[0];
            }
            catch (MappingException mappingException) {
                throw new QueryException(mappingException);
            }
        }

        public Type getReturnType(Type type, Mapping mapping) {
            int n = this.determineJdbcTypeCode(type, mapping);
            if (type == StandardBasicTypes.BIG_INTEGER) {
                return StandardBasicTypes.BIG_INTEGER;
            }
            if (type == StandardBasicTypes.BIG_DECIMAL) {
                return StandardBasicTypes.BIG_DECIMAL;
            }
            if (type == StandardBasicTypes.LONG || type == StandardBasicTypes.SHORT || type == StandardBasicTypes.INTEGER) {
                return StandardBasicTypes.LONG;
            }
            if (type == StandardBasicTypes.FLOAT || type == StandardBasicTypes.DOUBLE) {
                return StandardBasicTypes.DOUBLE;
            }
            if (n == 6 || n == 8 || n == 3 || n == 7) {
                return StandardBasicTypes.DOUBLE;
            }
            if (n == -5 || n == 4 || n == 5 || n == -6) {
                return StandardBasicTypes.LONG;
            }
            return type;
        }
    }

    public static class MinFunction
    extends StandardSQLFunction {
        public static final MinFunction INSTANCE = new MinFunction();

        public MinFunction() {
            super("min");
        }
    }

    public static class MaxFunction
    extends StandardSQLFunction {
        public static final MaxFunction INSTANCE = new MaxFunction();

        public MaxFunction() {
            super("max");
        }
    }

    public static class AvgFunction
    extends StandardSQLFunction {
        public static final AvgFunction INSTANCE = new AvgFunction();

        public AvgFunction() {
            super("avg", StandardBasicTypes.DOUBLE);
        }

        public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
            int n = this.determineJdbcTypeCode(type, sessionFactoryImplementor);
            return this.render(n, list.get(0).toString(), sessionFactoryImplementor);
        }

        protected final int determineJdbcTypeCode(Type type, SessionFactoryImplementor sessionFactoryImplementor) throws QueryException {
            try {
                int[] nArray = type.sqlTypes(sessionFactoryImplementor);
                if (nArray.length != 1) {
                    throw new QueryException("multiple-column type in avg()");
                }
                return nArray[0];
            }
            catch (MappingException mappingException) {
                throw new QueryException(mappingException);
            }
        }

        protected String render(int n, String string, SessionFactoryImplementor sessionFactoryImplementor) {
            return "avg(" + this.renderArgument(string, n) + ")";
        }

        protected String renderArgument(String string, int n) {
            return string;
        }
    }

    public static class CountFunction
    extends StandardSQLFunction {
        public static final CountFunction INSTANCE = new CountFunction();

        public CountFunction() {
            super("count", StandardBasicTypes.LONG);
        }

        public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) {
            if (list.size() > 1 && "distinct".equalsIgnoreCase(list.get(0).toString())) {
                return this.renderCountDistinct(list);
            }
            return super.render(type, list, sessionFactoryImplementor);
        }

        private String renderCountDistinct(List list) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("count(distinct ");
            String string = "";
            Iterator iterator = list.iterator();
            iterator.next();
            while (iterator.hasNext()) {
                stringBuilder.append(string).append(iterator.next());
                string = ", ";
            }
            return stringBuilder.append(")").toString();
        }
    }
}

