/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.TemplateRenderer;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.type.Type;

public class SQLFunctionTemplate
implements SQLFunction {
    private final Type type;
    private final TemplateRenderer renderer;
    private final boolean hasParenthesesIfNoArgs;

    public SQLFunctionTemplate(Type type, String string) {
        this(type, string, true);
    }

    public SQLFunctionTemplate(Type type, String string, boolean bl) {
        this.type = type;
        this.renderer = new TemplateRenderer(string);
        this.hasParenthesesIfNoArgs = bl;
    }

    public String render(Type type, List list, SessionFactoryImplementor sessionFactoryImplementor) {
        return this.renderer.render(list, sessionFactoryImplementor);
    }

    public Type getReturnType(Type type, Mapping mapping) throws QueryException {
        return this.type;
    }

    public boolean hasArguments() {
        return this.renderer.getAnticipatedNumberOfArguments() > 0;
    }

    public boolean hasParenthesesIfNoArguments() {
        return this.hasParenthesesIfNoArgs;
    }

    public String toString() {
        return this.renderer.getTemplate();
    }
}

